/* Reporter js script to obtain analysis date from OTF file
   Miles Thornton 6/12/2004

PROGRAM::date.js
DESC::Analysis date
FOLDER::OTF or d3hsp file
RETURN::text
ARG::OTF file name::%DEFAULT_DIR%/d3hsp
END_INFO
*/

if (arguments.length == 0) throw Error("no otf file argument\n");

var otf_file = new File(
  File.DriveMapFilename(arguments[0], Include.NATIVE),
  File.READ
);
var line;
var match_regex = new RegExp("Start time\\s+([0-9\\/]+)\\s+");
var result;

while ((line = otf_file.FindLineContaining("Start time")) != File.EOF) {
  result = line.match(match_regex);
  if (result != null) {
    output(result[1]);
    break;
  }
}

otf_file.Close();
