/* Reporter script to create a data file for D3Plot from a csv file
   Miles Thornton   21/10/2005

PROGRAM::data_file_from_csv.js
DESC::Create a D3Plot data file from a csv file
FOLDER::D3Plot data file
RETURN::text
ARG::CSV filename::%DEFAULT_DIR%/data.csv
ARG::Data file to create::%DEFAULT_DIR%/d3plot_data.file
ARG::Column for data point X coord::1
ARG::Column for data point Y coord::2
ARG::Column for data point Z coord::3
ARG::Column for data point value::4
ARG::Number of lines to skip at the top of the file::0
ARG::Column for link for reporter files (0 = no link)::0
ARG::Column for link for html files (0 = no link)::0
ARG::Column for link for pdf files (0 = no link)::0
ARG::Additional data file (false = no file)::false
EXPAND_ARGS::false
END_INFO
*/

if (arguments.length != 11)
    throw Error("Wrong number of arguments to data_file_from_csv.js. Expected 11 but got " +
                arguments.length +
                "\n");

var filename = Template.GetCurrent().ExpandVariablesInString(arguments[0]);
filename = File.DriveMapFilename(filename, Include.NATIVE);

// Look for the csv file
if (File.Exists(filename) == false)
    throw Error("Input file " + arguments[0] + " does not exist in data_file_from_csv.js\n");

var inputFiles = new Array();
var fileIn;
var fileOut;
var line;
var vregex = new RegExp("%(\\w+)%");

// Open output file
var filename = Template.GetCurrent().ExpandVariablesInString(arguments[1]);
filename = File.DriveMapFilename(filename, Include.NATIVE);

fileOut = new File(filename, File.WRITE);
fileOut.Write("$ Point data\n");

// Loop over all of the lines in the input file

var filename = Template.GetCurrent().ExpandVariablesInString(arguments[0]);
filename = File.DriveMapFilename(filename, Include.NATIVE);
fileIn = new File(filename, File.READ);

var nlines = 0;
while ( (line = fileIn.ReadLine() ) != File.EOF)
{
    nlines++;
    if (nlines <= arguments[6]) continue;

    var fields = line.split(",");
// Write this data point to the file
    write_data_point(fields, arguments);
}

fileIn.Close();


// Add any additional data

var filename = Template.GetCurrent().ExpandVariablesInString(arguments[9]);
filename = File.DriveMapFilename(filename, Include.NATIVE);
if (arguments[10] != false && File.Exists(filename))
{
    fileIn = new File(filename, File.READ);

    while ( (line = fileIn.ReadLine() ) != File.EOF)
    {
        fileOut.Write(line + "\n");
    }

    fileIn.Close();
}

// Close the output file
fileOut.Close();

//////////////////////////////////////////////////////////////////////

function write_data_point(f, args)
{
// Write a data point. If any of the data is missing it is not written

    for (var i=2; i<=5; i++)
        if (args[i] == undefined || args[i] == 0) return;

    var xc = args[2];
    var yc = args[3];
    var zc = args[4];
    var vc = args[5];

    for (var i=7; i<=9; i++)
        if (args[i] == undefined) return;

    var ol = args[7];
    var hl = args[8];
    var pl = args[9];

    if (f[xc-1] == undefined) return;
    var x = f[xc-1];

    if (f[yc-1] == undefined) return;
    var y = f[yc-1];

    if (f[zc-1] == undefined) return;
    var z = f[zc-1];

    if (f[vc-1] == undefined) return;
    var v = f[vc-1];

    fileOut.Write("data " + x + " " + y + " " + z  + " " + v + "\n");

// Reporter hyperlink
    if (ol)
    {
        if (f[ol-1] != undefined && f[ol-1])
        {
            v = Template.GetCurrent().ExpandVariablesInString(f[ol-1]);
            v = File.DriveMapFilename(v, Include.NATIVE);
            fileOut.Write("link_opr " + v + "\n");
        }
    }

// HTML hyperlink
    if (hl)
    {
        if (f[hl-1] != undefined && f[hl-1])
        {
            v = Template.GetCurrent().ExpandVariablesInString(f[hl-1]);
            v = File.DriveMapFilename(v, Include.NATIVE);
            fileOut.Write("link_html " + v + "\n");
        }
    }

// PDF hyperlink
    if (pl)
    {
        if (f[pl-1] != undefined && f[pl-1])
        {
            v = Template.GetCurrent().ExpandVariablesInString(f[pl-1]);
            v = File.DriveMapFilename(v, Include.NATIVE);
            fileOut.Write("link_pdf " + v + "\n");
        }
    }

    fileOut.Write("$\n");
}
