/* Reporter js script to obtain CPU time from OTF file
   Miles Thornton 7/12/2004

PROGRAM::cpu_time.js
DESC::CPU time for analysis
FOLDER::OTF or d3hsp file
RETURN::text
ARG::OTF file name::%DEFAULT_DIR%/d3hsp
END_INFO
*/

if (arguments.length == 0) throw Error("no otf file argument\n");

// Look for any otf files from restarts e.g. otf01, otf02 etc
var otf_filename = File.DriveMapFilename(arguments[0], Include.NATIVE);
for (var i = 1; i < 99; i++) {
  var nstring = i.toString();
  if (nstring.length == 1) nstring = nstring.replace(/^/, "0");
  var test_filename = otf_filename + nstring;
  if (File.Exists(test_filename)) otf_filename = test_filename;
  else break;
}

var line;
var match_regex = new RegExp(
  "Total CPU time.*?\\(\\s+(\\d+\\s+hours\\s+\\d+\\s+minutes\\s+\\d+\\s+seconds)\\)"
);
var result;

// We do 2 passes (if required). On the 1st pass try reading the last 5000 bytes in the file
// to see if the data is there. If it isn't we do a 2nd pass starting from the beginning of
// the file.
var start_pass = 1;
var finished = false;

// Get file size and subtract 5000 from it for position to start read from
var size = File.Size(otf_filename) - 5000;
if (size < 0) start_pass = 2;

for (var pass = start_pass; pass <= 2; pass++) {
  var otf_file = new File(otf_filename, File.READ);

  // Jump to the start position if 1st pass
  if (pass == 1) otf_file.Seek(size);

  while ((line = otf_file.FindLineContaining("Total CPU time")) != File.EOF) {
    if ((result = line.match(match_regex)) != null) {
      output(result[1]);
      finished = true;
      break;
    }
  }

  otf_file.Close();

  if (finished) break;
}
