/* Reporter js script to obtain comments from keyword file
   Miles Thornton 2/3/2005

PROGRAM::comments.js
DESC::Comments between *KEYWORD and *TITLE
FOLDER::Keyword file
RETURN::text
ARG::Keyword file name::%DEFAULT_DIR%/%DEFAULT_JOB%.key
-ARG::Maximum number (optional)
END_INFO
*/

if (arguments.length == 0)
    throw Error("no keyword file argument\n");

var key_file = new File(File.DriveMapFilename(arguments[0], Include.NATIVE), File.READ);
var read_title = false;
var max_comments = 99999999;
if (arguments.length == 2) max_comments = arguments[1];
var line;
var comment_regex = new RegExp("^\\$(.*)");
var title_regex   = new RegExp("^\\*TITLE");
var result;
var n = 0;

// Read until we get to *KEYWORD
while ( (line = key_file.FindLineStarting("*KEYWORD") ) != File.EOF)
{
// Now read any comments until *TITLE
    while ( (line = key_file.ReadLine() ) != File.EOF)
    {
        if (line.search(title_regex) != -1)
        {
            read_title = true;
            break;
        }
        else if (max_comments)
        {
            if ((result = line.match(comment_regex)) == null) continue;
            if (n) output("\n");
            output(result[1]);
            max_comments--;
            n++;
        }
    }

    if (read_title) break;
}

key_file.Close();
