//Hide: TRUE
// PLEASE RENAME THIS FILE TO "write_hook.js" IF YOU WANT TO ACTIVATE IT

// The script should be placed in primer_library/scripts/hooks
// These can be placed in the admin, install, home or current working directories.
// These directories are in descending order of preference where "admin" is preferred over "install", and so on.
// In case there are multiple scripts in multiple locations, then PRIMER will use the one located at the highest preference.

// For more information, please refer to the PRIMER Manual section: "Scripting > Using JavaScript in PRIMER > Write Hook".

// This is an example script for the Write Hook.
// It allows users to run a script just before the keyout process
// and additionaly it allows them to abort or proceed with the keyout

// Arguments which are passed to this script
var rule      = arguments[0];    // The name of the rule
var model_obj = arguments[1];    // Model object
var hook_obj  = arguments[2];    // The object which contains various write hook options (see below)

// ==== Write Hook Object Variables
// hook_obj.hook_instance        // The constant which represents the instance where the hook is triggered:
//                                  Model.WRITE_MODEL
//                                  Model.WRITE_INCLUDE_TREE
//                                  Model.WRITE_DIALOGUE
//                                  Model.WRITE_SELECT_INCLUDES
// hook_obj.include_files        // Array of include file names
// hook_obj.include_numbers      // Array of include file numbers

var writeHook_obj = new Object();  // Single global object

writeHook_setup_gui();
writeHook_obj.win_main.Show();

Window.StartLoop();

function writeHook_setup_gui()
/*       =================
*
* Sets up the GUI
*/
{
    var ypos = 1;
    var xpos = 3;
    var max_strlen;

    var hook_path;
    var mod_num;
    var mod_title;
    var model_write_opt;
    var incl_info;
    var proceed_button;
    var proceed_hover;
    
    var win_main = new Window("Write Hook", 0.5, 0.80, 0.5, 0.51);
    Window.Theme(Window.THEME_CURRENT);
    win_main.onClose = Quit;
    writeHook_obj.win_main = win_main;

// Set maximum string length, used to control GUI panel width
    max_strlen = Widget.StringLength("Hook Path: " + rule);
    max_strlen = Math.max(max_strlen,Widget.StringLength("Model Number: " + model_obj.number));
    max_strlen = Math.max(max_strlen,Widget.StringLength("Model Title: " + model_obj.title));
    max_strlen = Math.max(max_strlen,Widget.StringLength("Hook Instance: Model Tab"));
    max_strlen = Math.max(max_strlen,Widget.StringLength("Hook Instance: Dialogue Box"));
    max_strlen = Math.max(max_strlen,Widget.StringLength("Hook Instance: Include file, number: " + hook_obj.include_numbers[0]));
    max_strlen = Math.max(max_strlen,Widget.StringLength("Hook Instance: Select Files"));

    for (i=0; i<hook_obj.include_numbers.length; i++)
    {
        max_strlen = Math.max(max_strlen,Widget.StringLength("Include File #" + hook_obj.include_numbers[i] + " Name: " + hook_obj.include_files[i]) + 3);
    }

// Display some of the details on the script
    hook_path = new Widget(writeHook_obj.win_main, Widget.LABEL, xpos + 1, max_strlen + 1, ypos, ypos + 8, "Hook Path: "   + rule            ); ypos = ypos + 9;
    mod_num   = new Widget(writeHook_obj.win_main, Widget.LABEL, xpos + 1, max_strlen + 1, ypos, ypos + 8, "Model Number: "+ model_obj.number); ypos = ypos + 9;
    mod_title = new Widget(writeHook_obj.win_main, Widget.LABEL, xpos + 1, max_strlen + 1, ypos, ypos + 8, "Model Title: " + model_obj.title ); ypos = ypos + 9;
    
    switch(hook_obj.hook_instance) 
    {
       case Model.WRITE_MODEL:
             model_write_opt = new Widget(writeHook_obj.win_main, Widget.LABEL, xpos + 1, max_strlen + 1, ypos, ypos + 8, "Hook Instance: Model Tab"                                           ); ypos = ypos + 9;
             break;
       case Model.WRITE_DIALOGUE:
             model_write_opt = new Widget(writeHook_obj.win_main, Widget.LABEL, xpos + 1, max_strlen + 1, ypos, ypos + 8, "Hook Instance: Dialogue Box"                                        ); ypos = ypos + 9;
             break;
       case Model.WRITE_INCLUDE_TREE:
             model_write_opt = new Widget(writeHook_obj.win_main, Widget.LABEL, xpos + 1, max_strlen + 1, ypos, ypos + 8, "Hook Instance: Include file, number: " + hook_obj.include_numbers[0]); ypos = ypos + 9;
             break;
       case Model.WRITE_SELECT_INCLUDES:
             model_write_opt = new Widget(writeHook_obj.win_main, Widget.LABEL, xpos + 1, max_strlen + 1, ypos, ypos + 8, "Hook Instance: Select Files"                                        ); ypos = ypos + 9;
             break;
    }
    
// List selected include files
    for (i=0; i<hook_obj.include_numbers.length; i++)
    {
        incl_info = new Widget(writeHook_obj.win_main, Widget.LABEL, xpos + 1, max_strlen + 1, ypos, ypos + 8, "Include File #" + hook_obj.include_numbers[i] + " Name: " + hook_obj.include_files[i]); ypos = ypos + 9;
        incl_info.justify = Widget.LEFT;
    }

// Justify all the buttons to the left
    hook_path.justify       = Widget.LEFT;
    mod_num.justify         = Widget.LEFT;
    mod_title.justify       = Widget.LEFT;
    model_write_opt.justify = Widget.LEFT;	

// Setup the abort and proceed buttons
    writeHook_obj.AbortKey = new Widget(writeHook_obj.win_main, Widget.BUTTON, xpos + 1, Math.round(xpos + max_strlen/2), ypos, ypos + 8, "Abort");
    writeHook_obj.AbortKey.onClick    = AbortKeyout;
    writeHook_obj.AbortKey.background = Widget.DARKRED;
    writeHook_obj.AbortKey.foreground = Widget.WHITE;
    writeHook_obj.AbortKey.hover      = "Abort Keyout";
        
// Different button text for the Select Include Files method in the Model Tab instance
    if(Options.keyout_method == Include.SELECT && hook_obj.hook_instance != Model.WRITE_SELECT_INCLUDES) 
	{
	    proceed_button = "Select Files";
	    proceed_hover  = "Continue to Select Include Files panel";
	}
	else
	{
	    proceed_button = "Proceed";
	    proceed_hover  = "Proceed with Keyout";
	}
    writeHook_obj.GoKey = new Widget(writeHook_obj.win_main, Widget.BUTTON, Math.round(xpos + max_strlen/2) + 1, xpos + max_strlen, ypos, ypos + 8, proceed_button);
    writeHook_obj.GoKey.onClick    = ProceedKeyout;
    writeHook_obj.GoKey.background = Widget.DARKGREEN;
    writeHook_obj.GoKey.foreground = Widget.WHITE;
    writeHook_obj.GoKey.hover      = proceed_hover;

    return writeHook_obj;
}

/* === Callback functions for exiting the script === */

function AbortKeyout()
/*       ===========
* Set keyout interrupt to true if we want to abort keyout.
* Calling Exit() with a 'true' argument from a write_hook.js script will allow you to interrupt 
* the keyout of the model so that nothing is written out.
*/
{
	Window.EndLoop();
    Exit(true);
}

function ProceedKeyout()
/*       =============
* Set keyout interrupt to false if we want to keyout to proceed normally.
* Calling Exit() with a 'false' argument in a write_hook.js script allows the keyout of the model 
* to proceed as normal.
*/
{
	Window.EndLoop();
    Exit(false);
}



function Quit()
/*       ====
* Quit from the script
* Calling Exit() without an argument simply exits the script in a similar manner to Exit(true).
*/
{
	Window.EndLoop();
    Exit();
}
