Requires(26840);

/* This script demonstrates the New User Interface widgets (created by Andrew White, Oct 2019)*/
Window.Theme(Window.THEME_CURRENT);


var dy = 1;
var dx = 3;
var xl = 0;
var xr = 0;
var yt = 0;
var yb = 0;
var bwidth = 40;
var bheight = 8;
var cols = 4;

var category = new Array();
var categoryname = new Array();
var hover = new Array();

category[ 0] = Widget.CATEGORY_GENERIC;        categoryname[ 0] = "Generic";         hover[ 0] = "CATEGORY_GENERIC"
category[ 1] = Widget.CATEGORY_GENERIC_2;      categoryname[ 1] = "Generic_2";       hover[ 1] = "CATEGORY_GENERIC_2"
category[ 2] = Widget.CATEGORY_TOGGLE;         categoryname[ 2] = "Toggle";          hover[ 2] = "CATEGORY_TOGGLE"
category[ 3] = Widget.CATEGORY_TOOL;           categoryname[ 3] = "Tool";            hover[ 3] = "CATEGORY_TOOL"
category[ 4] = Widget.CATEGORY_KEYWORD;        categoryname[ 4] = "Keyword";         hover[ 4] = "CATEGORY_KEYWORD"
category[ 5] = Widget.CATEGORY_WARNING_ACTION; categoryname[ 5] = "Warning Action";  hover[ 5] = "CATEGORY_WARNING_ACTION"
category[ 6] = Widget.CATEGORY_SAFE_ACTION;    categoryname[ 6] = "Safe Action";     hover[ 6] = "CATEGORY_SAFE_ACTION"
category[ 7] = Widget.CATEGORY_HELP;           categoryname[ 7] = "Help";            hover[ 7] = "CATEGORY_HELP"
category[ 8] = Widget.CATEGORY_APPLY;          categoryname[ 8] = "Apply";           hover[ 8] = "CATEGORY_APPLY"
category[ 9] = Widget.CATEGORY_UPDATE;         categoryname[ 9] = "Update";          hover[ 9] = "CATEGORY_UPDATE"
category[10] = Widget.CATEGORY_DISMISS;        categoryname[10] = "Dismiss";         hover[10] = "CATEGORY_DISMISS"
category[11] = Widget.CATEGORY_CANCEL;         categoryname[11] = "Cancel";          hover[11] = "CATEGORY_CANCEL"
category[12] = Widget.CATEGORY_UNDO;           categoryname[12] = "Undo";            hover[12] = "CATEGORY_UNDO"
category[13] = Widget.CATEGORY_SEL_ALL;        categoryname[13] = "Select All";      hover[13] = "CATEGORY_SEL_ALL"
category[14] = Widget.CATEGORY_UNSEL_ALL;      categoryname[14] = "Unselect All";    hover[14] = "CATEGORY_UNSEL_ALL"
category[15] = Widget.CATEGORY_OPERATE;        categoryname[15] = "Operate";         hover[15] = "CATEGORY_OPERATE"
category[16] = Widget.CATEGORY_ENTITY;         categoryname[16] = "Entity";          hover[16] = "CATEGORY_ENTITY"


var gui = MakeGUI();

gui.win.Show(false);


function MakeGUI() {
    var gui = new Object();
    gui.UIButton = new Array();

    gui.win = new Window("New UI Demo", 0.70, 0.71, 0.7, 0.71);

    yb = yt + bheight;
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + dx, xl + 150, yt, yb, "These are all the button categories that can be defined through JavaScript:")
    gui.Label.justify = Widget.LEFT;

/* Loop through all button categories */
    for (var i = 0; i < category.length; i++) {

        if (i % cols == 0)
        {
            xr = 0;
            yt = yb + dy;
            yb = yt + bheight
        }
        xl = xr + dx;
        xr = xl + bwidth;
        gui.UIButton[i] = new Widget(gui.win, Widget.BUTTON, xl, xr, yt, yb, categoryname[i]);
        gui.UIButton[i].category = category[i];
        gui.UIButton[i].hover = hover[i];

        /* Escape button actions by default do whatever function is assigned to a button named Dismiss or Cancel therefore we need to define an action for them here */
        if (categoryname[i] == "Dismiss") gui.UIButton[i].onClick = Quit;
        if (categoryname[i] == "Cancel") gui.UIButton[i].onClick = Quit;

    }
    /* Actually make the toggle button able to toggle */
    gui.UIButton[2].toggle = true;

/* Other widgets */
    yt = yb + dy;
    yb = yt + bheight;
    gui.Label = new Widget(gui.win, Widget.LABEL, xl, xl + 180, yt, yb, "These are some other widgets. This is their default appearance, i.e. no category specification required:")
    gui.Label.justify = Widget.LEFT;

    /* Tickbox */
    yt = yb + dy;
    yb = yt + bheight;
    gui.TickBox = new Widget(gui.win, Widget.CHECKBOX, xl, xl + bheight, yt, yb);
    gui.TickBox.pushed = true;
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bheight + dx, xl + bheight + dx + 100, yt, yb, "This is a checkbox/tickbox");
    gui.Label.justify = Widget.LEFT;

    /* Textbox */
    yt = yb + dy;
    yb = yt + bheight;
    gui.TextBox = new Widget(gui.win, Widget.TEXTBOX, xl, xl + bwidth, yt, yb);
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 100, yt, yb, "This is a textbox");
    gui.Label.justify = Widget.LEFT;

    /* A Textbox that changes colour */
    yt = yb + dy;
    yb = yt + bheight;
    gui.TextBox2 = new Widget(gui.win, Widget.TEXTBOX, xl, xl + bwidth, yt, yb);
    gui.TextBox2.onChange = TextChange;
    gui.TextBox2.category = Widget.CATEGORY_WARNING_ACTION;  /* Starts empty so give it the appropriate category */
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 200, yt, yb, "This is a textbox that changes category");
    gui.Label.justify = Widget.LEFT;
    yt = yb + dy;
    yb = yt + bheight;
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 200, yt, yb, "Empty or not a number = warning; 1 = latent; 2 = black on yellow; otherwise = normal");
    gui.Label.justify = Widget.LEFT;

    /* Combobox */
    yt = yb + dy;
    yb = yt + bheight;
    var cb = new Widget(gui.win, Widget.COMBOBOX, xl, xl + bwidth, yt, yb);
    var wi = new WidgetItem(cb, "Item1");
    var wi = new WidgetItem(cb, "Item2");
    var wi = new WidgetItem(cb, "Item3");
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 100, yt, yb, "This is a combobox");
    gui.Label.justify = Widget.LEFT;

/* Other widgets category specification required */
    yt = yb + dy;
    yb = yt + bheight;
    gui.Label = new Widget(gui.win, Widget.LABEL, xl, xl + 180, yt, yb, "These are other widgets where category specification is required:")
    gui.Label.justify = Widget.LEFT;

    /* Tab */
    yt = yb + dy;
    yb = yt + bheight;
    gui.UITab = new Widget(gui.win, Widget.BUTTON, xl, xl + bwidth, yt, yb)
    gui.UITab.category = Widget.CATEGORY_TAB;
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 100, yt, yb, "This is a tab");
    gui.Label.justify = Widget.LEFT;

    /* Table row */
    yt = yb + dy;
    yb = yt + bheight;
    gui.UITableRow = new Widget(gui.win, Widget.BUTTON, xl, xl + bwidth, yt, yb)
    gui.UITableRow.category = Widget.CATEGORY_TABLE_ROW;
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 100, yt, yb, "This is a table row");
    gui.Label.justify = Widget.LEFT;

    /* Message */
    yt = yb + dy;
    yb = yt + bheight;
    gui.UIMessage = new Widget(gui.win, Widget.LABEL, xl, xl + bwidth, yt, yb, "A warning message")
    gui.UIMessage.category = Widget.CATEGORY_MESSAGE;
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 100, yt, yb, "This is a message");
    gui.Label.justify = Widget.LEFT;

    /* Labelbox */
    yt = yb + dy;
    yb = yt + bheight;
    gui.UILabelBox = new Widget(gui.win, Widget.LABEL, xl, xl + bwidth, yt, yb, "A label box")
    gui.UILabelBox.category = Widget.CATEGORY_LABEL_BOX;
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 100, yt, yb, "This is a label with a box");
    gui.Label.justify = Widget.LEFT;

/* Colours */
    yt = yb + dy;
    yb = yt + bheight;
    gui.Label = new Widget(gui.win, Widget.LABEL, xl, xl + 180, yt, yb, "These are some colours that can be set that change according to theme. Fill and line colours are shown below:")
    gui.Label.justify = Widget.LEFT;

    /*COLOUR_NEUTRAL*/
    yt = yb + dy;
    yb = yt + bheight;
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl, xl + bwidth/2, yt, yb)
    gui.ColourLabel.Rectangle(Widget.COLOUR_NEUTRAL, true, 20, 20, 80, 80);
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl+bwidth/2, xl + bwidth, yt, yb)
    gui.ColourLabel.Line(Widget.COLOUR_NEUTRAL, 20, 20, 80, 80);
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 200, yt, yb, "COLOUR_NEUTRAL: A neutral colour, usually used for window dressing.");
    gui.Label.justify = Widget.LEFT;

    /*COLOUR_CONTRAST*/
    yt = yb + dy;
    yb = yt + bheight;
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl, xl + bwidth/2, yt, yb)
    gui.ColourLabel.Rectangle(Widget.COLOUR_CONTRAST, true, 20, 20, 80, 80);
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl+bwidth/2, xl + bwidth, yt, yb)
    gui.ColourLabel.Line(Widget.COLOUR_CONTRAST, 20, 20, 80, 80);
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 200, yt, yb, "COLOUR_CONTRAST: A colour that will contrast with the theme background.");
    gui.Label.justify = Widget.LEFT;

    /*COLOUR_CONTRAST_2*/
    yt = yb + dy;
    yb = yt + bheight;
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl, xl + bwidth/2, yt, yb)
    gui.ColourLabel.Rectangle(Widget.COLOUR_CONTRAST_2, true, 20, 20, 80, 80);
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl+bwidth/2, xl + bwidth, yt, yb)
    gui.ColourLabel.Line(Widget.COLOUR_CONTRAST_2, 20, 20, 80, 80);
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 200, yt, yb, "COLOUR_CONTRAST_2: A different colour that will contrast with the theme background.");
    gui.Label.justify = Widget.LEFT;

    /*COLOUR_SAFE*/
    yt = yb + dy;
    yb = yt + bheight;
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl, xl + bwidth/2, yt, yb)
    gui.ColourLabel.Rectangle(Widget.COLOUR_SAFE, true, 20, 20, 80, 80);
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl+bwidth/2, xl + bwidth, yt, yb)
    gui.ColourLabel.Line(Widget.COLOUR_SAFE, 20, 20, 80, 80);
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 200, yt, yb, "COLOUR_SAFE: A colour that is generally used to indicate safe actions (similar in all themes).");
    gui.Label.justify = Widget.LEFT;

    /*COLOUR_WARNING*/
    yt = yb + dy;
    yb = yt + bheight;
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl, xl + bwidth/2, yt, yb)
    gui.ColourLabel.Rectangle(Widget.COLOUR_WARNING, true, 20, 20, 80, 80);
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl+bwidth/2, xl + bwidth, yt, yb)
    gui.ColourLabel.Line(Widget.COLOUR_WARNING, 20, 20, 80, 80);
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 200, yt, yb, "COLOUR_WARNING: A colour that is generally used to indicate dangerous actions (similar in all themes).");
    gui.Label.justify = Widget.LEFT;

    /*COLOUR_TITLE*/
    yt = yb + dy;
    yb = yt + bheight;
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl, xl + bwidth/2, yt, yb)
    gui.ColourLabel.Rectangle(Widget.COLOUR_TITLE, true, 20, 20, 80, 80);
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl+bwidth/2, xl + bwidth, yt, yb)
    gui.ColourLabel.Line(Widget.COLOUR_TITLE, 20, 20, 80, 80);
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 200, yt, yb, "COLOUR_TITLE: A colour used for the title bars.");
    gui.Label.justify = Widget.LEFT;

    /*COLOUR_LABEL*/
    yt = yb + dy;
    yb = yt + bheight;
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl, xl + bwidth/2, yt, yb)
    gui.ColourLabel.Rectangle(Widget.COLOUR_LABEL, true, 20, 20, 80, 80);
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl+bwidth/2, xl + bwidth, yt, yb)
    gui.ColourLabel.Line(Widget.COLOUR_LABEL, 20, 20, 80, 80);
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 200, yt, yb, "COLOUR_LABEL: A colour used for labels, i.e. background is the box colour, foreground depends on theme.");
    gui.Label.justify = Widget.LEFT;

    /*COLOUR_INVERSE*/
    yt = yb + dy;
    yb = yt + bheight;
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl, xl + bwidth/2, yt, yb)
    gui.ColourLabel.Rectangle(Widget.COLOUR_INVERSE, true, 20, 20, 80, 80);
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl+bwidth/2, xl + bwidth, yt, yb)
    gui.ColourLabel.Line(Widget.COLOUR_INVERSE, 20, 20, 80, 80);
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 200, yt, yb, "COLOUR_INVERSE: An inverse colour, i.e. black or white depending on theme.");
    gui.Label.justify = Widget.LEFT;
    
    /*COLOUR_LATENT*/
    yt = yb + dy;
    yb = yt + bheight;
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl, xl + bwidth/2, yt, yb)
    gui.ColourLabel.Rectangle(Widget.COLOUR_LATENT, true, 20, 20, 80, 80);
    gui.ColourLabel = new Widget(gui.win, Widget.LABEL, xl+bwidth/2, xl + bwidth, yt, yb)
    gui.ColourLabel.Line(Widget.COLOUR_LATENT, 20, 20, 80, 80);
    gui.Label = new Widget(gui.win, Widget.LABEL, xl + bwidth + dx, xl + bheight + dx + 200, yt, yb, "COLOUR_LATENT: A colour that is used for the latent condition.");
    gui.Label.justify = Widget.LEFT;

    gui.win.onClose = Quit;
    
    gui.UIButton[7].onClick = Help;

    return gui;


}


function Quit() {
    Exit();
}

function TextChange() {
    if (this.text.length == 0 || isNaN(this.text)) {
        gui.TextBox2.category = Widget.CATEGORY_WARNING_ACTION;
    }
    else if (this.text == 1)
    {
        gui.TextBox2.category = Widget.NO_CATEGORY;
        gui.TextBox2.foreground = Widget.BLACK;
        gui.TextBox2.background = Widget.COLOUR_LATENT;
    }
    else if (this.text == 2)
    {
        gui.TextBox2.category = Widget.NO_CATEGORY;
        gui.TextBox2.foreground = Widget.BLACK;
        gui.TextBox2.background = Widget.YELLOW;
    }
    else
    {
        gui.TextBox2.category = Widget.CATEGORY_TEXT_BOX;
        gui.TextBox2.foreground = Widget.DEFAULT;
        gui.TextBox2.background = Widget.DEFAULT;
    }
    
    gui.win.Redraw();
}

function Help() {
    var help_text = " New User Interface demo\n";
    help_text +=    "-------------------------\n";
    help_text += " \n";
    help_text += " This script demonstrates the new user interface categories\n";
    help_text += " that can be applied to buttons and other widgets.\n";
    help_text += " See the JavaScript API manual for more details.\n";

    Window.Information("Help", help_text);
}