// This example FE PID rule sets the FE PID for spotwelds.
// It is called data.nlayers-1 times with data.layer set to 0, 1, 2 etc
// It will set the PID to 1000 + layer
// e.g. if the spotweld has 3 layers then the beams/solids between layers:
//    0 and 1 will be 1000
//    1 and 2 will be 1001

var rule  = arguments[0];	// The name of the rule
var model = arguments[1];	// The model the connection is being made in
var data  = arguments[2];	// The rule data

// data.label		Connection label
// data.type		Connection type (Conx.SPOTWELD, Conx.ADHESIVE or Conx.SPOTWELD_LINE)
// data.subtype		Connection type (Conx.SPOTWELD_BEAM, Conx.SPOTWELD_SOLID1, ADHESIVE_SOLID etc)
// data.nlayers		How many layers the connection has
// data.nrings		How many rings the connection has [if remeshing]
// data.coords		The coordinates of the connection
// data.layer		The layer we want to specify PID for
// data.pid		Array of layer parts (length nlayers)
// data.mid		Array of layer materials(length nlayers)
// data.thickness	Array of layer thicknesses (length nlayers)
// data.weldpid		Array of spotweld parts (usually only 1)
// data.weldmid		Array of spotweld materials (usually only 1)
// data.remesh		false as script not called as remesh rule
// data.fepid		true as script called as a FE PID rule

if (data.fepid)
{

// Add 1000 on to layer ID
    Conx.SetRuleFEPID(1000 + data.layer);
}
