// This example remesh rule adds 1000 to the PID for rings around the spotweld
// e.g. if the spotweld connects parts 100 and 101 the PID for elements
// in the rings will be 1100 and 1101

// This rule is called for each ring of every layer in the connection.
// data.layer and data.ring will be set

var rule  = arguments[0];	// The name of the rule
var model = arguments[1];	// The model the connection is being made in
var data  = arguments[2];	// The remeshing data

// data.label		Connection label
// data.type		Connection type (Conx.SPOTWELD)
// data.subtype		Connection type (Conx.SPOTWELD_BEAM, Conx.SPOTWELD_SOLID1 etc)
// data.nlayers		How many layers the connection has
// data.nrings		How many rings the connection has
// data.coords		The coordinates of the connection
// data.layer		The layer we want to specify PID for
// data.ring		The ring we want to specify PID for
// data.pid		Array of layer parts (length nlayers)
// data.mid		Array of layer materials(length nlayers)
// data.thickness	Array of layer thicknesses (length nlayers)
// data.ringdiameter	Array of ring diameters (length nrings)
// data.weldpid		Array of spotweld parts (usually only 1)
// data.weldmid		Array of spotweld materials (usually only 1)
// data.remesh		true as script called as remesh rule
// data.fepid		false as script not called as a FE PID rule

if (data.remesh)
{
// Add 1000 on to PID
    if (data.ring != -1)
    {
        Conx.SetRulePID(1000 + data.pid[data.layer]);
    }
}
