// JavaScript to post-process SWFORC file into a D3PLOT user defined data componenet
//
// name:Swforc
// description:Read SWFORC file
//
// Date: 21 July 2008
// Version: 1.0
//New UI:
Window.Theme(Window.THEME_CURRENT);

var n = get_window_max_frame(1);

set_current_model(1);
set_current_state(1);

var spot_f = create_ubin_component("Spotweld Force", U_SOSH, U_SCALAR, REPLACE);
var spot_s = create_ubin_component("Spotweld Shear", U_SOSH, U_SCALAR, REPLACE);
var spot_d = create_ubin_component("Spotweld Failure", U_SOSH, U_SCALAR, REPLACE);

var d3s = 2; // d3plot state

var ft = 0; // timestep flag
var fc = 0; // timestep check flag

var f, line; // file variables

var eco1 = 0; // element counter
var eid = new Array(); // element id array
var efor = {}; // element force object
var eshe = {}; // element shear object
var efai = {}; // element shear object

var tco1 = 0; // timestep counter
var t = new Array(); // timestep array

var data = 0;
var tmp = 0;

var sw_file = Window.GetFilename("Select file", "Select the SWFORC file");
if (sw_file == null) Exit();
if (!File.Exists(sw_file))
{
  Warning("File selected does not exist, exiting script");
  Exit();
}

f = new File(sw_file , File.READ);
while ( (line = f.ReadLongLine()) != undefined)
{
// get time 
  if (ft==1 && fc==1)
  {
    tco1 = tco1 + 1;
    t[tco1] = Number(line.slice(39,50));
    Message("Reading SWFORC Time State " + tco1);
    fc = 0;
  }

  if (ft==1)
  {
//check to see if data has finished
    var echk=line.slice(49,50);
    if (echk=="")
    {
      ft = 0;
    }
  }

// start to process element if timestep flag = 1
  if (ft==1)
  {
// check to see if spotweld is a solid element
    var etype=line.slice(72,77);
    if (etype=="solid")
    {
      eco1 = eco1 +1;
// setup element array for first state
      if (tco1==1)
      {
        eid[eco1] = Number(line.slice(80,91));
        efor[eco1] = new Object();
        eshe[eco1] = new Object();
        efai[eco1] = new Object();
      }
      efor[eco1][tco1] = Number(line.slice(12,24));
      eshe[eco1][tco1] = Number(line.slice(25,37));
      efai[eco1][tco1] = Number(line.slice(51,59));
    }
  }

// search for 'time' if found go in processing loop
  var time=line.slice(46,50);
  if (time=="time")
  {
    ft = 1;
    fc = 1;
    eco1 = 0;
  }
}

// Close the file
f.Close();

// first state
for(var i=1; i<=eco1; i++)
{
  var elmid = eid[i] ;
  data = efor[i][1];
  put_ubin_data(spot_f, SOLID, -elmid, 1, data, 1);
  data = eshe[i][1];
  put_ubin_data(spot_s, SOLID, -elmid, 1, data, 1);
  data = efai[i][1];
  put_ubin_data(spot_d, SOLID, -elmid, 1, data, 1);
}
Message ("Done State 1");

// intermediate states
for(var j=1; j<=(n-1); j++)
{
  d3s = j+1;
  set_current_state(d3s);
  var d3t = GetTime(d3s);
  
  for(var m=2; m<=(tco1); m++)
  {
    var tsh = tco1;
    var tsl = tco1 - 1;

    tmp = t[m];
    var factor = 1;	
    if (tmp > d3t)
    {
      tsh = m;
      tsl = m - 1;
      factor = (d3t-t[tsl])/(t[tsh] - t[tsl]);
      m = tco1;
    }
  }
  
// Populate user data
  for(i=1; i<=eco1; i++)
  {  
    elmid = eid[i]; 

    var datal = efor[i][tsl];
    var datah = efor[i][tsh];
    data = ((datah-datal)*(factor)) + datal
    put_ubin_data(spot_f, SOLID, -elmid, 1, data, d3s);

    datal = eshe[i][tsl];
    datah = eshe[i][tsh];
    data = ((datah-datal)*(factor)) + datal
    put_ubin_data(spot_s, SOLID, -elmid, 1, data, d3s);

    datal = efai[i][tsl];
    datah = efai[i][tsh];
    data = ((datah-datal)*(factor)) + datal
    put_ubin_data(spot_d, SOLID, -elmid, 1, data, d3s);
  }
  Message("Done State " + d3s);
}
