#!/bin/bash
#
#     Author: Jonathan Moxey
#     Date  : 28/03/19
#
#     (LINUX_ONLY)
# ... Small script to move the helveticons to the correct "size_XX" directory
#     Not super robust, but don't have a lot of time to develop it further.
#
icon_dir="$HOME/SOURCE/icons_dir/helveticons"
IFS='
' # split on newline only

#
if [ ! -d $icon_dir ]; then
  while read -ep "Can't locate your icons_dir, please specify it's directory: " icon_dir; do
      if [ -d "${icon_dir}" ]; then
        echo "${icon_dir} exists, continuing..."
        break
      fi 
  done
fi
#
while read -ep "Which directory are the icons in? " file_dir; do
    if [ -d "${file_dir}" ]; then
         echo "${file_dir} exists"
         break
    fi 
done
#
while read -ep "What is the icon name? " icon_name; do
  echo "Placing ${icon_name} into size directories..."
  break
done
#
# ... Now do the work of putting them in the correct place
#
FILES=$file_dir/*.png
for dir in $FILES; do 
#   This png goes to size_16
  if [[ "$dir" == *"16x16"* ]]; then 
    echo $dir
    cp "$dir" ${icon_dir}/size_16/${icon_name%.*}.png
  fi
#   This png goes to size_24
  if [[ "$dir" == *"24x24"* ]]; then 
    echo $dir
    cp "$dir" ${icon_dir}/size_24/${icon_name%.*}.png
  fi
#   This png goes to size_32
  if [[ "$dir" == *"32x32"* ]]; then 
    echo $dir
    cp "$dir" ${icon_dir}/size_32/${icon_name%.*}.png
  fi
#   This png goes to size_42
  if [[ "$dir" == *"48x48"* ]]; then 
    echo $dir
    cp "$dir" ${icon_dir}/size_48/${icon_name%.*}.png
  fi
done
#
# ... They should now be in the correct place want to convert as well?
#
read -p "Do you want to convert these PNGs to BMP?" -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  if [ -e $icon_dir/convert_to_bmp.sh ]; then
    sh ./convert_to_bmp.sh
  else
    echo "Can't find the conversion script. Exiting..."
  fi
fi

