#!/bin/bash
#
#     Author : Jonathan Moxey
#     Date   : 28/03/19
#
#     (LINUX ONLY)
# ... Most Helveticons are PNG but we need to convert to BMP to be used with our software
#     This small script will loop the directories and convert all PNG to BMP with the correct
#     settings.
#     It will also remove the old png image from the directory.
#
echo "Starting PNG to BMP conversion..."

for filename in ./{size_16,size_24,size_32,size_48}/*.png ; do
  [ -f "$filename" ] || break
  convert "$filename" -alpha remove BMP3:"${filename%.*}.bmp"
  rm "${filename%.*}.png";
  echo "Done"
done
 
