/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
//disable_items();
refresh_job_control_status();
run_primer();
rerun_this();

/**
 * #AAW REPORTER run PRIMER rerun T/HIS
 *
 * Refreshes the value of JOB_CONTROL and checks for Abort.
 */
function refresh_job_control_status() {
    LogPrint(`Checking job control status...`);
    generate_item(`#AAW REPORTER read variables from PRIMER job control`);

    let template = Template.GetCurrent();
    let job_control = template.GetVariableValue(`JOB_CONTROL`);
    LogPrint(`Job control status is: "${job_control}"`);
    if (job_control == `Abort`) {
        LogPrint(`Generation aborted (job control).`);
        Exit();
    }
}

/**
 * #AAW REPORTER run PRIMER rerun T/HIS
 *
 * Runs the `#AAW PRIMER user data GUI` item if necessary.
 */
function run_primer() {
    let template = Template.GetCurrent();

    /* Check whether we need to run PRIMER*/
    let job_control = template.GetVariableValue(`JOB_CONTROL`);
    if (job_control == `Check`) {
        generate_item(`#AAW PRIMER user data GUI`);
        refresh_job_control_status();
    }
}

/**
 * #AAW REPORTER run PRIMER rerun T/HIS
 *
 * Reruns the `#AAW T/HIS Run` item if necessary.
 * Rerunning is necessary if the check of report contents against user data failed
 * the first time and the PRIMER GUI was launched to give the user the opportunity
 * to update the user data.
 */
function rerun_this() {
    let template = Template.GetCurrent();

    /* Check whether we need to rerun T/HIS item*/
    let job_control = template.GetVariableValue(`JOB_CONTROL`);
    if (job_control == `Skip`) {
        LogPrint(`No need to rerun T/HIS item.`);
        return;
    }
    if (job_control != `Run`) {
        LogError(`Unexpected value of <JOB_CONTROL = ${job_control}> in function rerun_this.`);
        return;
    }

    /* If we reach here, then we need to rerun T/HIS item. Because we are running it for the
     * second time, we won't check report contents against user data, so we proceed directly to
     * running the occupant assessment. Hence update JOB_CONTROL: */
    let job_control_var = new Variable(
        template,
        `JOB_CONTROL`,
        `"Check"/"Run"/"Skip"/"Abort" for #AAW items`,
        `Run`,
        `String`,
        false,
        true
    );
    generate_item(`#AAW THIS Run`);
    /** Need to refresh job_control status as we might need to stop generation to avoid running page duplication script */
    refresh_job_control_status();
}

/** Disable subsequant items reading result csv and duplicate page item if job_control is not Run */
function disable_items() {
    let template = Template.GetCurrent();

    /* Check whether we need to rerun T/HIS item*/
    let totalChannels = template.GetVariableValue(`totalChannels`);

    if (totalChannels) {
        deactivate_item(`#AAW REPORTER run Duplicate pages`);
    }
}

/**
 * Finds the first item in the template with the specified <item_name> and generates it.
 * Looks at the master page first, then all the normal pages.
 * @param {string} item_name The name of the item to be generated
 * @param {boolean} [expected = true] If true (default), will exit with an error if the requested item cannot be found
 * @example
 * generate_item(`#AAW REPORTER read variables from PRIMER job control`);
 */
function generate_item(item_name, expected = true) {
    let template = Template.GetCurrent();
    /* Loop through all pages in the template, searching for relevant items */
    let pages = template.GetAllPages();
    /* Add Master page to front so we consider it first */
    pages.unshift(template.GetMaster());
    let match = false;
    for (let p = 0; p < pages.length; p++) {
        let items = pages[p].GetAllItems();
        for (let item of items) {
            if (item.name.substring(0, item_name.length) == item_name) {
                LogPrint(`Found item "${item_name}" on page ${p + 1}. Generating...`);
                match = true;
                /* Activate the item before generating it, then return it to its original status */
                let active = item.active;
                item.active = true;
                item.Generate();
                item.active = active;
                break;
            }
        }
        if (match) break;
    }
    if (!match && expected) {
        LogError(`Could not find item "${item_name}" in order to generate it.`);
        Exit();
    }
}

function deactivate_item(item_name, expected = true) {
    let template = Template.GetCurrent();
    /* Loop through all pages in the template, searching for relevant items */
    let pages = template.GetAllPages();
    /* Add Master page to front so we consider it first */
    pages.unshift(template.GetMaster());
    let match = false;
    for (let p = 0; p < pages.length; p++) {
        let items = pages[p].GetAllItems();
        for (let item of items) {
            if (item.name.substring(0, item_name.length) == item_name) {
                LogPrint(`Found item "${item_name}" on page ${p + 1}. Deactivating...`);
                match = true;
                /* Activate the item before generating it, then return it to its original status */
                //let active = item.active;
                item.active = false;
                //item.Generate();
                //item.active = active;
                break;
            }
        }
        if (match) break;
    }
    if (!match && expected) {
        LogError(`Could not find item "${item_name}" in order to deactivate it.`);
        Exit();
    }
}
