/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */

duplicate_table_page();
duplicate_image_page();

function duplicate_table_page() {
    let template = Template.GetCurrent();
    let output_dir = Variable.GetFromName(template, "outputDirectory");
    let test_name = Variable.GetFromName(template, "testName");
    let format_version = Variable.GetFromName(template, "isoMmeFormat");
    let virtualTestingReferenceId = Variable.GetFromName(template, "virtualTestingReferenceId");

    let mme_file_path;
    if (format_version.value == "1.6") {
        if (virtualTestingReferenceId.value == "MISSING INPUT") {
            mme_file_path = `${output_dir.value}/${test_name.value}/${test_name.value}.mme`;
        } else {
            mme_file_path = `${output_dir.value}/${test_name.value}/${virtualTestingReferenceId.value}.mme`;
        }
    } else {
        mme_file_path = `${output_dir.value}/${test_name.value}/${test_name.value}.mme`;
    }
    if (!File.Exists(mme_file_path)) {
        LogPrint(`MME file does not exist at path: ${mme_file_path}`);
        return;
    }
    let mme_file = new File(mme_file_path, File.READ);
    let line;
    let array_of_mme_headers = [];

    /** Create array of mme headers by reading the file */
    //@ts-ignore
    while ((line = mme_file.ReadLine()) != File.EOF) {
        let colon_index = line.indexOf(":");
        let mme_header_description = line.substring(0, colon_index).trim();
        let mme_header_value = line.substring(colon_index + 1, line.length).trim();
        let mme_header_obj = {};
        mme_header_obj.description = mme_header_description;
        mme_header_obj.value = mme_header_value;
        array_of_mme_headers.push({ ...mme_header_obj });
    }
    mme_file.Close();

    let pages = template.GetAllPages();
    let success = false;

    let job_control = template.GetVariableValue(`JOB_CONTROL`);
    if (job_control != `Abort`) {
        for (let page in pages) {
            let items = pages[page].GetAllItems();
            for (let item of items) {
                /**
                 * Find the item named MME_HEADER_TABLE and duplicate that page
                 * */
                if (item.name.includes("MME_HEADER_TABLE")) {
                    let header_rows = 2; // There are two heeder rows in the table, so skip them while populating data
                    // Calculate number of additional pages required by dividing otal number of headers by available rows in table (which is total number of rows - header rows)
                    let num_of_additional_required_pages =
                        Math.ceil(array_of_mme_headers.length / (item.rows - header_rows)) - 1;

                    /** @type {Page[]} */
                    let array_of_dpages = [];
                    array_of_dpages.push(pages[page]); // Push original page first

                    /** Duplicate the page with MME_HEADER_TABLE and insert it after last page inserted by using page_index */
                    let page_index = 1;
                    for (let i = 0; i < num_of_additional_required_pages; i++) {
                        let all_pages = template.GetAllPages();
                        let dpage = pages[page].Duplicate(page_index++);
                        array_of_dpages.push(dpage);
                        LogPrint("array_of_dpages length: " + array_of_dpages.length);
                    }

                    /** Loop through array_of_dpages and add entries from array_of_mme_headers into it */
                    let start_index = 0;
                    for (let j = 0; j < array_of_dpages.length; j++) {
                        let items = Item.GetAll(array_of_dpages[j]);
                        for (let item of items) {
                            if (item.name.includes("MME_HEADER_TABLE")) {
                                for (let r = header_rows; r < item.rows; r++) {
                                    // Start populating from row header_rows index
                                    if (start_index >= array_of_mme_headers.length) {
                                        success = true;
                                        break;
                                    } // Break if we have populated all headers
                                    for (let c = 0; c < item.columns; c++) {
                                        let cell_obj = {};
                                        if (c == 0) cell_obj.text = array_of_mme_headers[start_index].description;
                                        else if (c == 1) cell_obj.text = array_of_mme_headers[start_index].value;
                                        item.SetCellProperties(cell_obj, r, c);
                                    }
                                    start_index++;
                                }
                            }
                            if (success) break;
                        }
                        if (success) break;
                    }
                    /** As we have found the page with item named channel1 mark it as success */
                    if (success) break;
                }
                if (success) break;
            }
            /** Break the looping through pages as we have found page which is containing item named channel1 */
            if (success) break;
        }
    }
}
/** Duplicate page and update the image item path based on number of channels output */
function duplicate_image_page() {
    let template = Template.GetCurrent();
    let output_dir = Variable.GetFromName(template, "OUTPUT_DIR");
    let format_version = Variable.GetFromName(template, "isoMmeFormat");
    let test_name = Variable.GetFromName(template, "testName");
    let total_channels = Variable.GetFromName(template, "totalChannels");
    let pages = template.GetAllPages();
    let success = false;

    let job_control = template.GetVariableValue(`JOB_CONTROL`);
    if (job_control != `Abort`) {
        for (let page in pages) {
            let items = pages[page].GetAllItems();
            for (let item of items) {
                /**
                 * Find the item named channel1 and duplicate that page
                 * There are two items that includes channel1 in its name.
                 * 1 - Channel label
                 * 2 - Channel image
                 * */
                if (item.name.includes("channel1")) {
                    /** @type {Page[]} */
                    let array_of_dpages = [];

                    /** Channel label above image */
                    let channel1_label_item = Item.GetFromName(pages[page], "channel1_label");
                    channel1_label_item.active = true;
                    channel1_label_item.text = `Channel 1 of ${total_channels.value}`;

                    /** Channel image */
                    let channel1_image_item = Item.GetFromName(pages[page], "channel1_image");
                    channel1_image_item.active = true;
                    channel1_image_item.file = `%OUTPUT_DIR%/images/%channel1%.png`;

                    LogPrint("Found item with name channel1");

                    /** Based on total_channels output duplicate that many number of pages and push it in array_of_dpages
                     * so later we can update image file path in it */
                    for (let i = 0; i < parseInt(total_channels.value) - 1; i++) {
                        let all_pages = template.GetAllPages();
                        let dpage = pages[page].Duplicate(all_pages.length);
                        array_of_dpages.push(dpage);
                        LogPrint("array_of_dpages length: " + array_of_dpages.length);
                    }

                    /** Loop through array_of_dpages and update filepath for any item that includes channel1 in its name */
                    for (let j = 0; j < array_of_dpages.length; j++) {
                        let items = Item.GetAll(array_of_dpages[j]);
                        for (let item of items) {
                            if (item.name.includes("channel1")) {
                                let channel_number = j + 2;
                                if (item.name.includes("label")) {
                                    /** Channel label above image */
                                    item.name = `channel${channel_number}_label`;
                                    item.text = `Channel ${channel_number} of ${total_channels.value}`;
                                } else {
                                    /** Channel image */
                                    item.name = `channel${channel_number}`;
                                    item.file = `%OUTPUT_DIR%/images/%channel${channel_number}%.png`;
                                }
                            }
                        }
                    }
                    /** As we have found the page with item named channel1 mark it as success */
                    success = true;
                    break;
                }
                if (success) break;
            }
            /** Break the looping through pages as we have found page which is containing item named channel1 */
            if (success) break;
        }
    }
}
