working_condition();

function working_condition() {
    let templ = Template.GetCurrent();
    let working_condition_var = Variable.GetFromName(templ, "WORKING_CONDITION");
    if (!working_condition_var) {
        LogWarning(`WORKING_CONDITION variable does not exist`);
        return;
    }
    let working_condition = working_condition_var.value;
    let ans = Window.GetInteger(
        `Working Condition`,
        `Input CNCAP Working Condition Number (` + working_condition + `)`
    );

    if (ans != null) {
        new Variable(
            templ,
            "WORKING_CONDITION",
            "Working condition number used in CNCAP protocol",
            ans.toString(),
            "Number",
            false,
            true
        );
        new Variable(
            templ,
            "SUMMARY_NAME",
            "Working condition name for summary template",
            "%[WORKING_CONDITION]% %WORKING_CONDITION%",
            "General",
            false,
            true
        );
    } else {
        new Variable(
            templ,
            "SUMMARY_NAME",
            "Working condition name for summary template",
            "CANCEL",
            "Number",
            false,
            true
        );
    }
}
