/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
pelvis_score();

/**
 * Performs the pelvis score calculation for the specified models
 */
function pelvis_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `pelvis`;

    let occupants = ["REAR_DRIVER_SIDE"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Pelvis force
             *
             * We should have either the left or right pelvis force, depending on the driver side, so it's
             * OK if one of them isn't there. Set required=false in get_variable_value() and then check
             * that we have at least one value */

            let pelvis_force_left_max;
            let pelvis_force_right_max;
            let pelvis_force_left_score;
            let pelvis_force_right_score;

            switch (occ) {
                case "REAR_DRIVER_SIDE":
                    pelvis_force_left_max = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_REAR_PASSENGER_LEFT_MAX_VALUE`,
                        "float",
                        false
                    );

                    pelvis_force_right_max = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_REAR_PASSENGER_RIGHT_MAX_VALUE`,
                        "float",
                        false
                    );

                    pelvis_force_left_score = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_REAR_PASSENGER_LEFT_MAX_SCORE`,
                        "float",
                        false
                    );

                    pelvis_force_right_score = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_REAR_PASSENGER_RIGHT_MAX_SCORE`,
                        "float",
                        false
                    );
                    break;

                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }

            /* Final max value will start at zero and will remain so if any variables were missing or invalid */
            /* Final score will start at one and will remain so if any variables were missing or invalid */
            let pelvis_force_max_value = 0;
            let pelvis_force_score = 1;

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                switch (occ) {
                    case "REAR_DRIVER_SIDE":
                        /*The pelvis score is sum of both the values*/

                        pelvis_force_max_value = Math.max(pelvis_force_left_max, pelvis_force_right_max);
                        pelvis_force_score = Math.max(pelvis_force_left_score, pelvis_force_right_score);
                        break;

                    default:
                        LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                        Exit();
                }

                LogPrint(`${m} ${occ} force = ${pelvis_force_max_value}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            if (occ == "REAR_DRIVER_SIDE") {
                let pelvis_final_score_var = new Variable(
                    templ,
                    `${m}_${occ}_PELVIS_FORCE_MAX_VALUE`,
                    `Maximum ${body_region_label} force`,
                    pelvis_force_max_value.toString(),
                    "String",
                    false,
                    true
                );

                let pelvis_force_score_var = new Variable(
                    templ,
                    `${m}_${occ}_PELVIS_FORCE_SCORE`,
                    `Maximum ${body_region_label} force score`,
                    pelvis_force_score.toString(),
                    "String",
                    false,
                    true
                );
            }
        }
    }
}
