draw_images();

function draw_images() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let output_dir = get_expanded_variable_value(templ, `OUTPUT_DIR`);

    /* Checks if the output directory provided is valid */
    if (is_valid_output_dir(output_dir) == false) {
        LogPrint("Invalid output directory");
        return;
    }

    let occupants = ["DRIVER", "REAR_DRIVER_SIDE"];

    for (let m of models) {
        for (let occ of occupants) {
            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            draw_ratings_bar_USNCAP(output_dir, m, occ);

            switch (occ) {
                case "DRIVER": {
                    let img = new Image(300, 342);

                    var BLACK_COL = "#000000"; // Black

                    let head_hic = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
                    let chest_score = get_variable_value(status, `${m}_${occ}_CHEST_COMPRESSION_SCORE`, "float");
                    let abdomen_score = get_variable_value(status, `${m}_${occ}_ABDOMEN_FORCE_MAX_SCORE`, "float");
                    let pelvis_score = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_SCORE`, "float");

                    draw_side_view_head(img, get_fill_colour_USNCAP(head_hic));
                    draw_side_view_chest(img, get_fill_colour_USNCAP(chest_score));
                    draw_side_view_abdomen(img, get_fill_colour_USNCAP(abdomen_score));
                    draw_side_view_pelvis(img, get_fill_colour_USNCAP(pelvis_score));

                    draw_side_view_neck(img, get_fill_colour_USNCAP(null));
                    draw_side_view_right_arm(img, get_fill_colour_USNCAP(null));
                    draw_side_view_right_leg(img, get_fill_colour_USNCAP(null));

                    draw_side_view_steering_wheel(img, BLACK_COL);

                    //Write out the image
                    img.Save(`${output_dir}/${m}_${occ.toLowerCase()}_plot.png`, Image.PNG);

                    break;
                }

                case "REAR_DRIVER_SIDE": {
                    let img = new Image(300, 342);

                    let head_hic = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
                    let pelvis_score = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_SCORE`, "float");

                    draw_side_view_head(img, get_fill_colour_USNCAP(head_hic));
                    draw_side_view_pelvis(img, get_fill_colour_USNCAP(pelvis_score));

                    draw_side_view_neck(img, get_fill_colour_USNCAP(null));
                    draw_side_view_chest(img, get_fill_colour_USNCAP(null));
                    draw_side_view_abdomen(img, get_fill_colour_USNCAP(null));
                    draw_side_view_right_arm_occupant(img);
                    draw_side_view_right_leg(img, get_fill_colour_USNCAP(null));

                    //Write out the image
                    img.Save(`${output_dir}/${m}_${occ.toLowerCase()}_plot.png`, Image.PNG);

                    break;
                }

                default:
                    LogError(`Unexpected occupant type "${occ}"`);
                    Exit();
            }
        }
    }
}
