/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
pelvis_score();

/* This function calculates Pelvis net force and probability values and write variables to the reporter */

function pelvis_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `pelvis`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */

        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Pelvis force
             *
             * We should have either the left or right pelvis force, depending on the driver side, so it's
             * OK if one of them isn't there. Set required=false in get_variable_value() and then check
             * that we have at least one value */

            /* These variables store the left and right max value for pelvis force */
            let pelvis_force_left_max;
            let pelvis_force_right_max;

            /* These variables store the left and right pelvis probabilities */
            let pelvis_force_left_score;
            let pelvis_force_right_score;

            switch (occ) {
                case "DRIVER":
                    pelvis_force_left_max = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_LEFT_MAX_VALUE`,
                        "float",
                        false
                    );
                    pelvis_force_right_max = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_RIGHT_MAX_VALUE`,
                        "float",
                        false
                    );
                    pelvis_force_left_score = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_LEFT_MAX_SCORE`,
                        "float",
                        false
                    );
                    pelvis_force_right_score = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_RIGHT_MAX_SCORE`,
                        "float",
                        false
                    );

                    break;
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let pelvis_force_max_value = 0;

            /* The net probability score is set to 1, because this is the worst case probabilty incase the variable is not modified in the below switch case*/
            let pelvis_force_score = 1;

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                switch (occ) {
                    case "DRIVER":
                        /* Max function here picks up the max value here among the variables */

                        pelvis_force_max_value = Math.max(pelvis_force_left_max, pelvis_force_right_max);
                        pelvis_force_score = Math.max(pelvis_force_left_score, pelvis_force_right_score);
                        break;
                    default:
                        LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                        Exit();
                }
                LogPrint(`${m} ${occ} ${body_region_label} force = ${pelvis_force_max_value}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            if (occ == "DRIVER") {
                /* Variables are written out to REPORTER */
                let pelvis_force_var = new Variable(
                    templ,
                    `${m}_${occ}_PELVIS_FORCE_MAX_VALUE`,
                    `Maximum ${body_region_label} force`,
                    pelvis_force_max_value.toString(),
                    "String",
                    false,
                    true
                );

                let pelvis_force_score_var = new Variable(
                    templ,
                    `${m}_${occ}_PELVIS_FORCE_SCORE`,
                    `Maximum ${body_region_label} force score`,
                    pelvis_force_score.toString(),
                    "String",
                    false,
                    true
                );
            }
        }
    }
}
