/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
overall_score();

/**
 * Performs the overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} probability score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            switch (occ) {
                case "DRIVER": {
                    let chest_prob = get_variable_value(status, `${m}_${occ}_CHEST_COMPRESSION_SCORE`, "float");
                    let head_prob = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
                    let left_femur_prob = get_variable_value(
                        status,
                        `${m}_${occ}_LEFT_FEMUR_COMPRESSION_SCORE`,
                        "float"
                    );
                    let neck_compression_exceedence_prob = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_COMPRESSION_EXCEEDENCE_SCORE`,
                        "float"
                    );
                    let neck_nij_prob = get_variable_value(status, `${m}_${occ}_NECK_NIJ_TOTAL_SCORE`, "float");
                    let neck_tension_exceedence_prob = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_TENSION_EXCEEDENCE_SCORE`,
                        "float"
                    );
                    let right_femur_prob = get_variable_value(
                        status,
                        `${m}_${occ}_RIGHT_FEMUR_COMPRESSION_SCORE`,
                        "float"
                    );

                    let input_scores = [
                        chest_prob,
                        head_prob,
                        left_femur_prob,
                        neck_compression_exceedence_prob,
                        neck_nij_prob,
                        neck_tension_exceedence_prob,
                        right_femur_prob
                    ];

                    /* If we have all the required variables, calculate the final scores */
                    if (status.success) {
                        let joint_probability = calculate_joint_probability_USNCAP(input_scores);
                        let relative_risk = calculate_relative_risk_USNCAP(joint_probability);

                        let total_prob_var = new Variable(
                            templ,
                            `${m}_${occ}_JOINT_PROB`,
                            `${occ} joint probability`,
                            joint_probability.toString(),
                            "String",
                            false,
                            true
                        );

                        let relative_risk_var = new Variable(
                            templ,
                            `${m}_${occ}_RELATIVE_RISK`,
                            `${occ} relative risk`,
                            relative_risk.toString(),
                            "String",
                            false,
                            true
                        );
                    } else {
                        warn_about_missing_or_invalid_variables(status, `${m} ${occ} overall score calculation`);
                    }

                    break;
                }

                case "FRONT_PASSENGER": {
                    let chest_prob = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_PASSENGER_SCORE`,
                        "float"
                    );
                    let head_prob = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
                    let left_femur_prob = get_variable_value(
                        status,
                        `${m}_${occ}_LEFT_FEMUR_COMPRESSION_PASSENGER_SCORE`,
                        "float"
                    );
                    let neck_compression_exceedence_prob = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_COMPRESSION_EXCEEDENCE_PASSENGER_SCORE`,
                        "float"
                    );
                    let neck_nij_prob = get_variable_value(status, `${m}_${occ}_NECK_NIJ_TOTAL_SCORE`, "float");
                    let neck_tension_exceedence_prob = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_TENSION_EXCEEDENCE_PASSENGER_SCORE`,
                        "float"
                    );
                    let right_femur_prob = get_variable_value(
                        status,
                        `${m}_${occ}_RIGHT_FEMUR_COMPRESSION_PASSENGER_SCORE`,
                        "float"
                    );

                    let input_scores = [
                        chest_prob,
                        head_prob,
                        left_femur_prob,
                        neck_compression_exceedence_prob,
                        neck_nij_prob,
                        neck_tension_exceedence_prob,
                        right_femur_prob
                    ];

                    /* If we have all the required variables, calculate the final scores */
                    if (status.success) {
                        /*Calculate Probability function calculates the net probability for the assessment by taking an array of probability scores*/
                        let joint_probability = calculate_joint_probability_USNCAP(input_scores);

                        /* Calculates the relative risk from the joint probability value computed above. */
                        let relative_risk = calculate_relative_risk_USNCAP(joint_probability);

                        let total_prob_var = new Variable(
                            templ,
                            `${m}_${occ}_JOINT_PROB`,
                            `${occ} joint probability`,
                            joint_probability.toString(),
                            "String",
                            false,
                            true
                        );

                        let relative_risk_var = new Variable(
                            templ,
                            `${m}_${occ}_RELATIVE_RISK`,
                            `${occ} relative risk`,
                            relative_risk.toString(),
                            "String",
                            false,
                            true
                        );
                    } else {
                        warn_about_missing_or_invalid_variables(status, `${m} ${occ} overall score calculation`);
                    }

                    break;
                }

                default:
                    LogError(`Unexpected occupant type "${occ}".`);
                    Exit();
            }
        }
    }
}
