/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
pelvis_score();

/**
 * Performs the pelvis calculation for the specified models
 */
function pelvis_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `pelvis`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Pelvis ratings */

            let pelvis_force_rating = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_RATING`, "string");

            /* Final ratings are set to fail and will remain so if any variables were missing or invalid */

            let overall_pelvis_rating = "Fail";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                overall_pelvis_rating = return_pass_or_fail([pelvis_force_rating]);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            new Variable(
                templ,
                `${m}_${occ}_PELVIS_RATING`,
                `${occ} overall pelvis rating`,
                overall_pelvis_rating,
                "String",
                false,
                true
            );
        }
    }
}
