/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
head_score();

/**
 * Performs the head calculation for the specified models
 */
function head_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `head`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Head ratings */

            let head_hic_rating = get_variable_value(status, `${m}_${occ}_HEAD_HIC_RATING`, "string");

            /* Final ratings are set to fail and will remain so if any variables were missing or invalid */

            let overall_head_rating = "Fail";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                overall_head_rating = return_pass_or_fail([head_hic_rating]);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            new Variable(
                templ,
                `${m}_${occ}_HEAD_RATING`,
                `${occ} overall head rating`,
                overall_head_rating,
                "String",
                false,
                true
            );
        }
    }
}
