/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
knee_femur_and_pelvis_score();

/**
 * Performs the knee and femur score calculation for the specified models
 */
function knee_femur_and_pelvis_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `knee femur and pelvis`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Knee and femur ratings */
            let variable_values = get_multiple_variable_values(
                status,
                [
                    `${m}_${occ}_LEFT_FEMUR_COMPRESSION_EXCEEDENCE_RATING`,
                    `${m}_${occ}_RIGHT_FEMUR_COMPRESSION_EXCEEDENCE_RATING`,
                    `${m}_${occ}_LEFT_KNEE_COMPRESSION_RATING`,
                    `${m}_${occ}_RIGHT_KNEE_COMPRESSION_RATING`
                ],
                "string",
                true
            );

            /* Final ratings are set to fail and will remain so if any variables were missing or invalid */
            let overall_knee_femur_rating = "Fail";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                overall_knee_femur_rating = return_pass_or_fail(Object.values(variable_values));
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            new Variable(
                templ,
                `${m}_${occ}_KNEE_FEMUR_RATING`,
                `${occ} overall femur rating`,
                overall_knee_femur_rating,
                "String",
                false,
                true
            );
        }
    }
}
