/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
overall_score();

/**
 * Performs the overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `overall`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        /*Overall score variable is initially set to False */
        let overall_rating_driver = "Fail";
        let overall_rating_passenger = "Fail";
        let overall_structural_rating = "Fail";

        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            if (occ == "DRIVER") {
                overall_structural_rating = get_variable_value(status, `${m}_STRUCTURAL_RATING`, "string");
            }

            let variable_values = get_multiple_variable_values(
                status,
                [`${m}_${occ}_HEAD_AND_NECK_RATING`, `${m}_${occ}_CHEST_RATING`, `${m}_${occ}_FEMUR_RATING`],
                "string",
                true
            );

            let overall_occupant_rating = "Fail";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                overall_occupant_rating = return_pass_or_fail(Object.values(variable_values));
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            new Variable(
                templ,
                `${m}_${occ}_RATING`,
                `${occ} overall rating`,
                overall_occupant_rating,
                "String",
                false,
                true
            );

            if (occ == "DRIVER") {
                overall_rating_driver = overall_occupant_rating;
            } else {
                overall_rating_passenger = overall_occupant_rating;
            }
        }

        /* Overall scores */
        let total_score = return_pass_or_fail([
            overall_rating_driver,
            overall_rating_passenger,
            overall_structural_rating
        ]);

        let total = new Variable(
            templ,
            `${m}_TOTAL_SCORE`,
            " Total score",
            total_score.toString(),
            "String",
            false,
            true
        );
    }
}
