overall_score();

/**
 * Performs the overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();

    let occupants = ["DRIVER", "FRONT_PASSENGER"];

    /* The following objects will be populated with values for each occupant */
    let head_score = {};
    let chest_score = {};
    let abdomen_score = {};
    let pelvis_score = {};

    let occ_score = {};

    let overall_weighting_factor = 14 / 24;
    let overall_max_limit = 14;

    new Variable(
        templ,
        "OVERALL_WEIGHTING_FACTOR",
        "Overall weighting factor",
        overall_weighting_factor.toString(),
        "String",
        false,
        true
    );

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} overall score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Body region final scores */
            head_score[occ] = get_variable_value(status, `${m}_${occ}_HEAD_FINAL_SCORE`, "float");
            chest_score[occ] = get_variable_value(status, `${m}_${occ}_CHEST_FINAL_SCORE`, "float");
            abdomen_score[occ] = get_variable_value(status, `${m}_${occ}_ABDOMEN_FINAL_SCORE`, "float");
            pelvis_score[occ] = get_variable_value(status, `${m}_${occ}_PELVIS_FINAL_SCORE`, "float");

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            occ_score[occ] = 0;

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Overall occupant score is sum of body region scores. */
                occ_score[occ] = head_score[occ] + chest_score[occ] + abdomen_score[occ] + pelvis_score[occ];
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ}  overall score calculation`);
            }

            new Variable(
                templ,
                `${m}_${occ}_OVERALL_SCORE`,
                `Overall ${occ} score`,
                occ_score[occ].toString(),
                "String",
                false,
                true
            );

            /* Get the evaluation level from the score */
            let evaluation_level = get_JNCAP_evaluation_level(occ_score[occ]);

            new Variable(
                templ,
                `${m}_${occ}_EVALUATION_LEVEL`,
                `${occ} evaluation level`,
                evaluation_level.toString(),
                "String",
                false,
                true
            );
        }

        let overall_score = (occ_score.DRIVER + occ_score.FRONT_PASSENGER) * overall_weighting_factor;

        /* Bound the overall score between upper and lower limits */
        overall_score = Math.max(Math.min(overall_score, overall_max_limit), 0);

        /*Sending values to reporter*/

        LogPrint(`${m} overall score = ${overall_score}`);

        new Variable(templ, `${m}_OVERALL_SCORE`, `Overall score`, overall_score.toString(), "String", false, true);
    }
}
