/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
overall_score();

/**
 * Performs the overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();

    let occupants = ["DRIVER", "FRONT_PASSENGER"];

    /* The following objects will be populated with values for each occupant */
    let head_score = {};
    let neck_score = {};
    let chest_score = {};
    let lower_leg_score = {};
    let occ_score = {};

    let overall_weighting_factor = 22 / 24;

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} overall score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Body region final scores */
            head_score[occ] = get_variable_value(status, `${m}_${occ}_HEAD_FINAL_SCORE`, "float");
            neck_score[occ] = get_variable_value(status, `${m}_${occ}_NECK_FINAL_SCORE`, "float");
            chest_score[occ] = get_variable_value(status, `${m}_${occ}_CHEST_ABDOMEN_FINAL_SCORE`, "float");
            lower_leg_score[occ] = get_variable_value(status, `${m}_${occ}_LOWER_LEG_FINAL_SCORE`, "float");

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            occ_score[occ] = 0;

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Overall occupant score is sum of body region scores. */
                occ_score[occ] = head_score[occ] + neck_score[occ] + chest_score[occ] + lower_leg_score[occ];

                LogPrint(`${m} ${occ} overall score = ${occ_score[occ]}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} overall score calculation`);
            }

            let overall_occ_score_var = new Variable(
                templ,
                `${m}_${occ}_OVERALL_SCORE`,
                `Overall ${occ} score`,
                occ_score[occ].toString(),
                "String",
                false,
                true
            );

            /* Get the evaluation level from the score */
            let evaluation_level = get_JNCAP_evaluation_level(occ_score[occ]);

            new Variable(
                templ,
                `${m}_${occ}_EVALUATION_LEVEL`,
                `${occ} evaluation level`,
                evaluation_level.toString(),
                "String",
                false,
                true
            );
        }

        let overall_score = 0.0;

        overall_score = (occ_score.DRIVER + occ_score.FRONT_PASSENGER) * overall_weighting_factor;

        LogPrint(`${m} overall score = ${overall_score}`);

        new Variable(templ, `${m}_OVERALL_SCORE`, `Overall score`, overall_score.toString(), "String", false, true);
    }
}
