/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
lower_leg_foot_and_ankle_rating();

/**
 * Performs the lower leg, foot and ankle rating calculation for the specified models
 */
function lower_leg_foot_and_ankle_rating() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `lower leg, foot and ankle`;
    let occupants;

    /* Create a status object to track whether REPORTER Variables are all present and valid.
     * <success> is initially true but will be set to false if anything missing or invalid. */
    let status = { success: true, missing: [], invalid: [] };

    let crash_test_type = get_variable_value(status, `TEMPLATE_CRASH_TEST`, "string");

    if (!status.success) {
        LogWarning(`Variable "TEMPLATE_CRASH_TEST" is missing for ${body_region_label} score calculation`);
        return;
    }

    if (crash_test_type == "ODB") {
        occupants = ["DRIVER"];
    } else if (crash_test_type == "SOB") {
        occupants = ["DRIVER", "FRONT_PASSENGER"];
    } else {
        LogWarning(
            `Variable "TEMPLATE_CRASH_TEST" value "${crash_test_type}" is invalid for ${body_region_label} score calculation`
        );
        return;
    }

    let sides = ["LEFT", "RIGHT"];
    let leg_rating = {};

    for (let m of models) {
        let lower_leg = {}; // To be populated with rating for each side
        let tibia_compression_max_val = {}; // To be populated with max value for each side
        let tibia_compression_rating = {}; // To be populated with rating for each side

        for (let occ of occupants) {
            for (let side of sides) {
                LogPrint(`Calculating ${m} ${occ} ${side} ${body_region_label} rating...`);

                /* Create a status object to track whether REPORTER Variables are all present and valid.
                 * <success> is initially true but will be set to false if anything missing or invalid. */
                let status = { success: true, missing: [], invalid: [] };
                // variables common to ODB and SOB template

                let variable_values = get_multiple_variable_values(
                    status,
                    [
                        `${m}_${occ}_${side}_KNEE_COMPRESSION_RATING`,
                        `${m}_${occ}_${side}_TIBIA_COMPRESSION_LOWER_MAX_RATING`,
                        `${m}_${occ}_${side}_TIBIA_COMPRESSION_UPPER_MAX_RATING`,
                        `${m}_${occ}_${side}_TIBIA_COMPRESSION_LOWER_MAX_RATING`,
                        `${m}_${occ}_${side}_TIBIA_COMPRESSION_UPPER_MAX_RATING`,
                        `${m}_${occ}_${side}_FOOT_ACCELERATION_RATING`,
                        `${m}_${occ}_${side}_TIBIA_INDEX_UPPER_MAX_RATING`,
                        `${m}_${occ}_${side}_TIBIA_INDEX_LOWER_MAX_RATING`
                    ],
                    "string",
                    true
                );

                /* ODB specific variables */
                let odb_variable_values = {};

                if (crash_test_type.toUpperCase() == "ODB") {
                    odb_variable_values = get_multiple_variable_values(
                        status,
                        [
                            `${m}_${occ}_${side}_FEMUR_COMPRESSION_RATING`,
                            `${m}_${occ}_${side}_FEMUR_COMPRESSION_EXCEEDENCE_RATING`
                        ],
                        "string",
                        true
                    );
                }

                leg_rating[side] = "[Not Calculated]";

                if (status.success) {
                    // overall ratings
                    let ratings = Object.values(variable_values);

                    if (crash_test_type.toUpperCase() == "ODB") {
                        ratings.push(...Object.values(odb_variable_values));
                    }

                    leg_rating[side] = return_worst_IIHS_rating(ratings);

                    LogPrint(`${m} ${occ} ${side} ${body_region_label} rating = ${leg_rating[side]}`);
                } else {
                    warn_about_missing_or_invalid_variables(
                        status,
                        `${m} ${occ} ${body_region_label} rating calculation`
                    );
                }

                let side_rating_var = new Variable(
                    templ,
                    `${m}_${occ}_${side}_LEG_FINAL_RATING`,
                    `Final ${side} ${body_region_label} rating`,
                    leg_rating[side].toString(),
                    "String",
                    false,
                    true
                );
                let leg_overall_rating = return_worst_IIHS_rating([leg_rating.LEFT, leg_rating.RIGHT]);

                let leg_overall_rating_var = new Variable(
                    templ,
                    `${m}_${occ}_LEG_OVERALL_RATING`,
                    `Final ${body_region_label} rating`,
                    leg_overall_rating.toString(),
                    "String",
                    false,
                    true
                );
            }
        }
    }
}
