/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
structural_rating();

function structural_rating() {
    let templ = Template.GetCurrent();
    let models = get_model_list();

    for (let m of models) {
        LogPrint(`Calculating ${m} structural rating...`);

        /* Create a status object to track whether REPORTER Variables are all present and valid.
         * <success> is initially true but will be set to false if anything missing or invalid. */

        let status = { success: true, missing: [], invalid: [] };

        let structural_rating = get_variable_value(status, `${m}_STRUCTURE_B_PILLAR_INTRUSION_RATING`, "string");

        if (status.success) {
            /* Try to get the structural downgrade value.
             * If it's not present, create it and set it to 0 */
            let downgrade_levels = get_variable_value(status, `${m}_STRUCTURAL_DOWNGRADE`, "int");

            if (!status.success) {
                downgrade_levels = 0;

                new Variable(
                    templ,
                    `${m}_STRUCTURAL_DOWNGRADE`,
                    `A variable to keep track of how much downgrade to be applied to structural rating`,
                    downgrade_levels.toString(),
                    "string",
                    false,
                    true
                );
            }

            let fuel_leak = get_variable_value(status, `${m}_FUEL_VOLTAGE_DOWNGRADE_DEMERIT`, "string");

            if (!status.success) {
                fuel_leak = "OK";

                new Variable(
                    templ,
                    `${m}_FUEL_VOLTAGE_DOWNGRADE_DEMERIT`,
                    `A variable to keep track of how much downgrade to be applied to structural rating`,
                    fuel_leak,
                    "string",
                    false,
                    true
                );
            }

            for (var i = 0; i < downgrade_levels; i++) {
                if (structural_rating == "Marginal") structural_rating = "Poor";
                if (structural_rating == "Acceptable") structural_rating = "Marginal";
                if (structural_rating == "Good") structural_rating = "Acceptable";
            }

            /** HG 15th Jan 2025 - A 2024 addition:
             * If a significant fuel leak or compromise of the high-voltage system occurs,
             * both the structural and overall ratings may be downgraded to poor */
            status = { success: true, missing: [], invalid: [] };
            var fuel_voltage_downgrade = get_variable_value(status, `${m}_FUEL_VOLTAGE_DOWNGRADE_DEMERIT`);
            if (status.success && fuel_voltage_downgrade == "Poor") {
                structural_rating = "Poor";
            }

            new Variable(
                templ,
                `${m}_STRUCTURAL_RATING`,
                `The overall structural rating`,
                structural_rating,
                "string",
                false,
                true
            );
        } else {
            warn_about_missing_or_invalid_variables(status, `${m} structural calculation`);
        }
    }
}
