/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
abdomen_score();

/**
 * Performs the chest and abdomen score calculation for the specified models
 */
function abdomen_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `abdomen`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Abdomen score and modifiers */

            let scores = get_multiple_variable_values(
                status,
                [
                    `${m}_${occ}_ABDOMEN_FORCE_FRONT_SCORE`,
                    `${m}_${occ}_ABDOMEN_FORCE_MIDDLE_SCORE`,
                    `${m}_${occ}_ABDOMEN_FORCE_BACK_SCORE`,
                    `${m}_${occ}_ABDOMEN_FORCE_MAX_SCORE`
                ],
                "float",
                true
            );

            let capping_limit_values = get_multiple_variable_values(
                status,
                [
                    `${m}_${occ}_ABDOMEN_FORCE_FRONT_CAPPING_LIMIT`,
                    `${m}_${occ}_ABDOMEN_FORCE_MIDDLE_CAPPING_LIMIT`,
                    `${m}_${occ}_ABDOMEN_FORCE_BACK_CAPPING_LIMIT`,
                    `${m}_${occ}_ABDOMEN_FORCE_MAX_CAPPING_LIMIT`
                ],
                "string",
                true
            );

            let incorrect_airbag_mod = get_variable_value(
                status,
                `${m}_ABDOMEN_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`,
                "int"
            );

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let abdomen_score = 0;
            let abdomen_score_before_mods = 0;

            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let abdomen_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Score calculation is different for different occupants */
                /* Abdomen score is minimum of top and bottom scores */
                abdomen_score_before_mods = Math.min(...Object.values(scores));

                /* Apply the modifier */
                abdomen_score = Math.max(0, abdomen_score_before_mods + incorrect_airbag_mod);

                LogPrint(`${m} ${occ} abdomen score = ${abdomen_score}`);

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */
                if (return_capping_limit(Object.values(capping_limit_values)) == "") {
                    abdomen_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_FINAL_SCORE`,
                "Final abdomen score",
                abdomen_score.toString(),
                "String",
                false,
                true
            );
            new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_CAPPING_LIMIT`,
                `Abdomen capping limit`,
                abdomen_capping_limit,
                "String",
                false,
                true
            );

            new Variable(
                templ,
                `${m}_ABDOMEN_CAPPING_LIMIT_EXPLANATION`,
                `Capping limit explanation`,
                capping_limit_explanation,
                "String",
                false,
                true
            );
        }
    }
}
