/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
knee_femur_and_pelvis_score();

/**
 * Performs the knee, femur and pelvis score calculation for the specified models
 */
function knee_femur_and_pelvis_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `knee, femur and pelvis`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    let sides = ["LEFT", "RIGHT"];
    let side_scores = {}; // To be populated with score for each side
    for (let m of models) {
        for (let occ of occupants) {
            for (let side of sides) {
                LogPrint(`Calculating ${m} ${occ} ${side} ${body_region_label} score...`);

                /* Create a status object to track whether REPORTER Variables are all present and valid.
                 * <success> is initially true but will be set to false if anything missing or invalid. */
                let status = { success: true, missing: [], invalid: [] };

                /* Variables extracted for all occupants */

                let scores = get_multiple_variable_values(
                    status,
                    [
                        `${m}_${occ}_${side}_FEMUR_COMPRESSION_EXCEEDENCE_SCORE`,
                        `${m}_${occ}_${side}_KNEE_COMPRESSION_SCORE`
                    ],
                    "float",
                    true
                );

                let modifiers = get_multiple_variable_values(
                    status,
                    [
                        `${m}_${occ}_${side}_KNEE_VARIABLE_CONTACT_MODIFIER`,
                        `${m}_${occ}_${side}_KNEE_CONCENTRATED_LOADING_MODIFIER`,
                        `${m}_${occ}_${side}_KNEE_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`
                    ],
                    "float",
                    true
                );

                /* Final scores all start at zero and will remain so if any variables were missing or invalid */
                side_scores[side] = 0;

                /* If we have all the required variables, calculate the final scores */
                if (status.success) {
                    /* Score calculation is different for different occupants */

                    /* Left/right score is minimum of femur and knee scores, summed with modifiers */
                    side_scores[side] = Math.max(
                        0,
                        Math.min(...Object.values(scores)) + Object.values(modifiers).reduce((a, b) => a + b, 0)
                    );

                    LogPrint(`${m} ${occ} ${side} ${body_region_label} score = ${side_scores[side]}`);
                } else {
                    warn_about_missing_or_invalid_variables(
                        status,
                        `${m} ${occ} ${body_region_label} score calculation`
                    );
                }

                new Variable(
                    templ,
                    `${m}_${occ}_KNEE_FEMUR_PELVIS_${side}_FINAL_SCORE`,
                    `Final ${side} ${body_region_label} score`,
                    side_scores[side].toString(),
                    "String",
                    false,
                    true
                );
            }

            /* Overall score for each occupant is minimum of left and right scores */
            let knee_femur_pelvis_final_score = Math.min(side_scores.LEFT, side_scores.RIGHT);

            new Variable(
                templ,
                `${m}_${occ}_KNEE_FEMUR_PELVIS_FINAL_SCORE`,
                `Final ${body_region_label} score`,
                knee_femur_pelvis_final_score.toString(),
                "String",
                false,
                true
            );
        }
    }
}
