/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
abdomen_score();

/**
 * Performs the head and neck score calculation for the specified models
 */
function abdomen_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `abdomen`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Chest ratings */

            let abdomen_force_front_rating = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_FORCE_FRONT_RATING`,
                "string"
            );
            let abdomen_force_middle_rating = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_FORCE_MIDDLE_RATING`,
                "string"
            );
            let abdomen_force_back_rating = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_FORCE_BACK_RATING`,
                "string"
            );

            /* Final scores is set to fail and will remain so if any variables were missing or invalid */
            let overall_abdomen_rating = return_pass_or_fail(["failString"]);

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                overall_abdomen_rating = return_pass_or_fail([
                    abdomen_force_front_rating,
                    abdomen_force_middle_rating,
                    abdomen_force_back_rating
                ]);

                new Variable(
                    templ,
                    `${m}_${occ}_ABDOMEN_RATING`,
                    `${occ} overall abdomen rating`,
                    overall_abdomen_rating,
                    "String",
                    false,
                    true
                );
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }
        }
    }
}
