/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
knee_femur_and_pelvis_score();

/**
 * Performs the femur score calculation for the specified models
 */
function knee_femur_and_pelvis_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `femur`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Knee and femur ratings */
            let left_femur_comp_rating = get_variable_value(
                status,
                `${m}_${occ}_LEFT_FEMUR_COMPRESSION_RATING`,
                "string"
            );

            let right_femur_comp_rating = get_variable_value(
                status,
                `${m}_${occ}_RIGHT_FEMUR_COMPRESSION_RATING`,
                "string"
            );

            /* Final ratings are set to fail and will remain so if any variables were missing or invalid */
            let overall_femur_rating = return_pass_or_fail(["failString"]);

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                overall_femur_rating = return_pass_or_fail([left_femur_comp_rating, right_femur_comp_rating]);

                new Variable(
                    templ,
                    `${m}_${occ}_FEMUR_RATING`,
                    `${occ} overall femur rating`,
                    overall_femur_rating,
                    "String",
                    false,
                    true
                );
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }
        }
    }
}
