/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
overall_score();

/**
 * Performs the overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `overall`;

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let head_neck_rating = get_variable_value(status, `${m}_${occ}_HEAD_AND_NECK_RATING`, "string");
            let chest_rating = get_variable_value(status, `${m}_${occ}_CHEST_RATING`, "string");
            let femur_rating = get_variable_value(status, `${m}_${occ}_FEMUR_RATING`, "string");

            let overall_rating_driver = return_pass_or_fail(["failString"]);
            let overall_rating_passenger = return_pass_or_fail(["failString"]);

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                if (occ == "DRIVER") {
                    overall_rating_driver = return_pass_or_fail([head_neck_rating, chest_rating, femur_rating]);
                }

                if (occ == "FRONT_PASSENGER") {
                    overall_rating_passenger = return_pass_or_fail([head_neck_rating, chest_rating, femur_rating]);
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            let occ_overall_rating = occ == "DRIVER" ? overall_rating_driver : overall_rating_passenger;

            new Variable(
                templ,
                `${m}_${occ}_RATING`,
                `${occ} overall rating`,
                occ_overall_rating,
                "String",
                false,
                true
            );

            /* Overall scores */
            let total_score = return_pass_or_fail(["failString"]);

            total_score = return_pass_or_fail([overall_rating_driver, overall_rating_passenger]);

            new Variable(templ, `${m}_TOTAL_SCORE`, " Total score", total_score.toString(), "String", false, true);
        }
    }
}
