/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
draw_occupant_images();

/**
 * Draw occupant body region scoring indicator images for the specified models
 */
function draw_occupant_images() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let output_dir = get_expanded_variable_value(templ, `OUTPUT_DIR`);

    /* Checks if the output directory provided is valid */
    if (is_valid_output_dir(output_dir) == false) {
        LogPrint("Invalid output directory");
        return;
    }

    let occupants = ["DRIVER", "FRONT_PASSENGER"];
    for (let m of models) {
        for (let occ of occupants) {
            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let head_rating = get_variable_value(status, `${m}_${occ}_HEAD_RATING`, "string");
            let neck_rating = get_variable_value(status, `${m}_${occ}_NECK_RATING`, "string");
            let chest_rating = get_variable_value(status, `${m}_${occ}_CHEST_RATING`, "string");
            let femur_rating = get_variable_value(status, `${m}_${occ}_FEMUR_RATING`, "string");

            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} body region score indicator images`);
            }

            /* Create new image */
            let img = new Image(190, 342);
            img.lineWidth = 1;
            img.lineColour = "black";

            /* Draw the body regions */
            let empty = null;
            draw_front_view_head(img, get_fill_colour_UN(head_rating));
            draw_front_view_neck(img, get_fill_colour_UN(neck_rating));

            draw_front_view_chest(img, get_fill_colour_UN(chest_rating));

            draw_front_view_abdomen(img, get_fill_colour_UN(empty)); // Not coloured in

            draw_front_view_left_femur(img, get_fill_colour_UN(femur_rating));

            draw_front_view_right_femur(img, get_fill_colour_UN(femur_rating));

            draw_front_view_left_tibia(img, get_fill_colour_UN(empty));

            draw_front_view_right_tibia(img, get_fill_colour_UN(empty));

            draw_front_view_left_foot(img, get_fill_colour_UN(empty));

            draw_front_view_right_foot(img, get_fill_colour_UN(empty));

            draw_front_view_left_arm(img, occ); // Not coloured in; occupant dependent

            draw_front_view_right_arm(img, occ); // Not coloured in; occupant dependent

            if (occ == "DRIVER") {
                draw_front_view_steering_wheel(img);
            }
            draw_front_view_seatbelt(img, occ);

            img.Save(`${output_dir}/${m}_${occ.toLowerCase()}_plot.png`, Image.PNG);
        }
    }
}
