/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
chest_score();

/**
 * Performs the chest and abdomen score calculation for the specified models
 */
function chest_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `chest`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Chest score and modifiers */

            /* Driver */
            let chest_comp_top_max_val;
            let chest_comp_middle_max_val;
            let chest_comp_bottom_max_val;
            let chest_comp_top_max_score;
            let chest_comp_middle_max_score;
            let chest_comp_bottom_max_score;
            let chest_vc_top_max_val;
            let chest_vc_middle_max_val;
            let chest_vc_bottom_max_val;
            let chest_vc_top_max_score;
            let chest_vc_middle_max_score;
            let chest_vc_bottom_max_score;
            let chest_vc_mod;
            let shoulder_left_lat_force_score;
            let shoulder_right_lat_force_score;
            let shoulder_left_lat_force_value;
            let shoulder_right_lat_force_value;
            let shoulder_mod;
            let chest_comp_max_01_capping_limit;
            let chest_comp_max_02_capping_limit;
            let chest_comp_max_03_capping_limit;

            let incorrect_airbag_mod = get_variable_value(
                status,
                `${m}_CHEST_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`,
                "int"
            );

            switch (occ) {
                case "DRIVER":
                    chest_comp_top_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_MAX_01_VALUE`,
                        "float"
                    );
                    chest_comp_middle_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_MAX_02_VALUE`,
                        "float"
                    );
                    chest_comp_bottom_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_MAX_03_VALUE`,
                        "float"
                    );
                    chest_comp_top_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_MAX_01_SCORE`,
                        "float"
                    );
                    chest_comp_middle_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_MAX_02_SCORE`,
                        "float"
                    );
                    chest_comp_bottom_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_MAX_03_SCORE`,
                        "float"
                    );
                    chest_vc_top_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_UPPER_MAX_VALUE`,
                        "float"
                    );
                    chest_vc_middle_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_MIDDLE_MAX_VALUE`,
                        "float"
                    );
                    chest_vc_bottom_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_LOWER_MAX_VALUE`,
                        "float"
                    );
                    chest_vc_top_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_UPPER_MAX_SCORE`,
                        "float"
                    );
                    chest_vc_middle_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_MIDDLE_MAX_SCORE`,
                        "float"
                    );
                    chest_vc_bottom_max_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_LOWER_MAX_SCORE`,
                        "float"
                    );
                    chest_comp_max_01_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_MAX_01_CAPPING_LIMIT`
                    );
                    chest_comp_max_02_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_MAX_02_CAPPING_LIMIT`
                    );
                    chest_comp_max_03_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_MAX_03_CAPPING_LIMIT`
                    );

                    shoulder_left_lat_force_score = get_variable_value(
                        status,
                        `${m}_${occ}_SHOULDER_LATERAL_FORCES_LEFT_MAX_SCORE`,
                        "int"
                    );
                    shoulder_right_lat_force_score = get_variable_value(
                        status,
                        `${m}_${occ}_SHOULDER_LATERAL_FORCES_RIGHT_MAX_SCORE`,
                        "int"
                    );
                    shoulder_left_lat_force_value = get_variable_value(
                        status,
                        `${m}_${occ}_SHOULDER_LATERAL_FORCES_LEFT_MAX_VALUE`,
                        "int"
                    );
                    shoulder_right_lat_force_value = get_variable_value(
                        status,
                        `${m}_${occ}_SHOULDER_LATERAL_FORCES_RIGHT_MAX_VALUE`,
                        "int"
                    );
                    /*chest modification is calculated based on the smaller of the chest scores*/
                    chest_vc_mod = Math.min(
                        chest_vc_bottom_max_score,
                        chest_vc_middle_max_score,
                        chest_vc_top_max_score
                    );
                    let chest_vc_var = new Variable(
                        templ,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_MODIFIER`,
                        "Chest VC Modifier",
                        chest_vc_mod.toString(),
                        "String",
                        false,
                        true
                    );

                    /*shoulder modification is calculated based on the minimum of the shoulder force scores*/
                    shoulder_mod = Math.min(shoulder_left_lat_force_score, shoulder_right_lat_force_score);
                    let shoulder_mod_var = new Variable(
                        templ,
                        `${m}_${occ}_SHOULDER_MODIFIER`,
                        "Shoulder Modifier",
                        shoulder_mod.toString(),
                        "String",
                        false,
                        true
                    );

                    break;
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let chest_score_before_mods = 0;
            let chest_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let chest_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Score calculation is different for different occupants */
                switch (occ) {
                    case "DRIVER":
                        /* Check capping limits. If any individual limits are exceeded, an asterisk is
                         * displayed for all parent body regions. */
                        if (
                            chest_comp_max_01_capping_limit == "" &&
                            chest_comp_max_02_capping_limit == "" &&
                            chest_comp_max_03_capping_limit == ""
                        ) {
                            chest_capping_limit = "";
                        } else {
                            capping_limit_explanation = `*Capping limit exceeded`;
                        }

                        /*We calculate the maximum of the left and right upper/lower values so we can display it in the table */
                        /* Chest score is minimum of left and right scores, summed with modifiers */

                        chest_score_before_mods = Math.min(
                            chest_comp_top_max_score,
                            chest_comp_middle_max_score,
                            chest_comp_bottom_max_score
                        );

                        chest_score = Math.max(
                            0,
                            chest_score_before_mods + shoulder_mod + chest_vc_mod + incorrect_airbag_mod
                        );
                        break;
                    default:
                        LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                        Exit();
                }

                LogPrint(`${m} ${occ} chest score = ${chest_score}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            if (occ == "DRIVER") {
                let chest_comp_score_var = new Variable(
                    templ,
                    `${m}_${occ}_CHEST_COMPRESSION_SCORE`,
                    "Minimum of left and right upper/lower compression scores",
                    chest_score_before_mods.toString(),
                    "String",
                    false,
                    true
                );
            }
            let chest_score_var = new Variable(
                templ,
                `${m}_${occ}_CHEST_FINAL_SCORE`,
                "Final chest score",
                chest_score.toString(),
                "String",
                false,
                true
            );
            let chest_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_CHEST_CAPPING_LIMIT`,
                `Chest capping limit`,
                chest_capping_limit,
                "String",
                false,
                true
            );
        }
        let capping_limit_explanation_var = new Variable(
            templ,
            `${m}_CHEST_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
