/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
overall_score();

/**
 * Performs the overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();

    let occupants = ["DRIVER", "FRONT_PASSENGER", "REAR_PASSENGER_SIDE"];

    /* The following objects will be populated with values for each occupant */
    let head_neck_score = {};
    let head_neck_score_pass = {};
    let head_neck_score_rear_pass = {};
    let chest_abdomen_score = {};
    let chest_abdomen_score_front_passenger = 0;
    let chest_abdomen_score_rear_passenger = 0;
    let knee_femur_pelvis_score = {};
    let lower_leg_foot_ankle_score = {};
    let occ_score = {};
    let occ_score_pass = {};
    let occ_score_rear_pass = {};
    let occ_capping_limit = {};

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} overall score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Body region final scores */
            head_neck_score[occ] = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_NECK_FINAL_POINTS`,
                "float",
                templ
            );
            head_neck_score_pass[occ] = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_NECK_FINAL_PASSENGER_POINTS`,
                "float",
                templ
            );
            head_neck_score_rear_pass[occ] = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_NECK_REAR_FINAL_POINTS`,
                "float",
                templ
            );
            chest_abdomen_score[occ] = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_CHEST_ABDOMEN_FINAL_POINTS`,
                "float",
                templ
            );
            chest_abdomen_score_front_passenger = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_FRONT_PASSENGER_CHEST_ABDOMEN_POINTS`,
                "float",
                templ
            );
            chest_abdomen_score_rear_passenger = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_REAR_PASSENGER_SIDE_CHEST_ABDOMEN_FINAL_PASSENGER_POINTS`,
                "float",
                templ
            );
            knee_femur_pelvis_score[occ] = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_KNEE_FEMUR_PELVIS_FINAL_POINTS`,
                "float",
                templ
            );
            lower_leg_foot_ankle_score[occ] = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_LOWER_LEG_FOOT_ANKLE_FINAL_POINTS`,
                "float",
                templ
            );

            /* Body region capping limits */
            let head_neck_capping_limit = get_variable_value(status, `${m}_${occ}_HEAD_NECK_CAPPING_LIMIT`, "string");
            let chest_capping_limit = get_variable_value(status, `${m}_${occ}_CHEST_CAPPING_LIMIT`, "string");

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            occ_score[occ] = 0;
            occ_score_pass[occ] = 0;
            occ_score_rear_pass[occ] = 0;
            occ_capping_limit[occ] = "*";

            /* If we have all the required variables, calculate the final scores */
            if (true) {
                /* Overall occupant score is sum of body region scores. */
                occ_score[occ] =
                    head_neck_score.DRIVER +
                    chest_abdomen_score.DRIVER +
                    knee_femur_pelvis_score.DRIVER +
                    lower_leg_foot_ankle_score.DRIVER;
                LogPrint(`${m} ${occ} overall score = ${occ_score[occ]}`);

                occ_score_pass[occ] =
                    head_neck_score_pass.FRONT_PASSENGER +
                    chest_abdomen_score_front_passenger +
                    knee_femur_pelvis_score.FRONT_PASSENGER +
                    lower_leg_foot_ankle_score.FRONT_PASSENGER;

                occ_score_rear_pass[occ] =
                    head_neck_score_rear_pass.REAR_PASSENGER_SIDE +
                    chest_abdomen_score_rear_passenger +
                    knee_femur_pelvis_score.REAR_PASSENGER_SIDE;

                occ_score = replaceNaNWithMissing(occ_score);
                occ_score_pass = replaceNaNWithMissing(occ_score_pass);
                occ_score_rear_pass = replaceNaNWithMissing(occ_score_rear_pass);

                /* Only remove the overall occupant capping limit if none of the body region
                 * capping limits were exceeded. */
                if (head_neck_capping_limit == "" && chest_capping_limit == "") {
                    occ_capping_limit[occ] = "";
                    LogPrint(`Capping limit not applied to ${m} ${occ}.`);
                } else {
                    LogPrint(`Capping limit applied to ${m} ${occ}.`);
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} overall score calculation`);
            }

            let overall_occ_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_OVERALL_POINTS`,
                `Overall ${occ} score`,
                occ_score[occ].toString(),
                "String",
                false,
                true
            );
            let overall_occ_score_pass_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_OVERALL_PASSENGER_POINTS`,
                `Overall Front Passenger score`,
                occ_score_pass[occ].toString(),
                "String",
                false,
                true
            );

            let overall_occ_score_rear_pass_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_OVERALL_REAR_PASSENGER_POINTS`,
                `Overall Front Passenger score`,
                occ_score_rear_pass[occ].toString(),
                "String",
                false,
                true
            );
        }

        let overall_score = 0.0;

        /* Overall capping limit applied if either occupant's capping limit exceeded */

        overall_score =
            head_neck_score.DRIVER +
            chest_abdomen_score.DRIVER +
            knee_femur_pelvis_score.DRIVER +
            lower_leg_foot_ankle_score.DRIVER +
            head_neck_score_pass.FRONT_PASSENGER +
            chest_abdomen_score_front_passenger +
            knee_femur_pelvis_score.FRONT_PASSENGER +
            lower_leg_foot_ankle_score.FRONT_PASSENGER +
            head_neck_score_rear_pass.REAR_PASSENGER_SIDE +
            chest_abdomen_score_rear_passenger +
            knee_femur_pelvis_score.REAR_PASSENGER_SIDE;

        overall_score = replaceNaNWithMissing(overall_score);

        let overall_score_var = new_variable_and_new_euroNCAP_banded_score(
            templ,
            `${m}_OVERALL_POINTS`,
            `Overall score`,
            overall_score.toString(),
            "String",
            false,
            true
        );
    }
}
