/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */

// In reporter, make sure to have this JS defined before all other scoring JS so that getModifierValue is defined

head_and_neck_score();

/**
 * Performs the head and neck score calculation for the specified models
 */
function getModifierValue(status, key) {
    const value = get_variable_value(status, key, "string");
    if (value == "Yes") {
        if (key.includes("CHEST_BELT_LOAD")) {
            return -40;
        }
        return -20;
    }
    if (value === "No") return 0;
    return parseFloat(value); // fallback if it's actually a number in string form
}
function head_and_neck_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `head and neck`;

    let occupants = ["DRIVER", "FRONT_PASSENGER", "REAR_PASSENGER_SIDE"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Head score and modifiers */

            /* Shared */
            let head_hic_score = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_HIC_SCORE`,
                "float",
                templ
            );
            let head_hic_score_banded = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE_ENCAP_BANDED`, "float");
            let head_peack_acc_score = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_PEAK_ACCELERATION_SCORE`,
                "float",
                templ
            );
            let head_three_ms_exc_score = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE`,
                "float",
                templ
            );
            let head_three_ms_exc_score_banded = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE_ENCAP_BANDED`,
                "float"
            );
            let head_hic_capping_limit = get_variable_value(status, `${m}_${occ}_HEAD_HIC_CAPPING_LIMIT`);
            let head_tms_capping_limit = get_variable_value(
                status,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_CAPPING_LIMIT`
            );

            let hb_mod = getModifierValue(status, `${m}_${occ}_HEAD_BOTTOMING_OUT_MODIFIER`);
            let haz_ab_mod = getModifierValue(status, `${m}_${occ}_HEAD_HAZARDOUS_AIRBAG_DEPLOYMENT_MODIFIER`);
            let inc_ab_mod = getModifierValue(status, `${m}_${occ}_HEAD_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`);
            let ab_con_mod = getModifierValue(status, `${m}_${occ}_HEAD_AIRBAG_CONTACT_MODIFIER`);
            let head_dmg_mod = getModifierValue(status, `${m}_FRONT_PASSENGER_HEAD_DAMAGE_MODIFIER`);
            let head_exc_mod = getModifierValue(status, `${m}_REAR_PASSENGER_SIDE_HEAD_EXCURSION_MODIFIER`);

            /* If the head peak acceleration is less than 80g and score is 4 other scores hic and 3 ms exc should be zero */

            /* Neck score */
            let neck_axial_tension_score;
            let neck_shear_score;
            let neck_extension_score;
            let neck_axial_tension_score_banded;
            let neck_shear_score_banded;
            let neck_extension_score_banded;
            let neck_axial_capping_limit;
            let neck_shear_capping_limit;
            let neck_shear_exceedence_capping_limit;
            let neck_tension_exceedence_capping_limit;
            let neck_extension_capping_limit;
            let neck_axial_tension_passenger_score;
            let neck_shear_passenger_score;
            let neck_extension_passenger_score;
            let neck_axial_tension_passenger_score_banded;
            let neck_shear_passenger_score_banded;
            let neck_extension_passenger_score_banded;

            switch (occ) {
                case "REAR_PASSENGER_SIDE":
                    neck_axial_tension_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_AXIAL_REAR_PASSENGER_SCORE`,
                        "float",
                        templ
                    );
                    neck_shear_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_SHEAR_REAR_PASSENGER_SCORE`,
                        "float",
                        templ
                    );
                    neck_extension_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_REAR_PASSENGER_SCORE`,
                        "float",
                        templ
                    );
                    neck_axial_tension_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_AXIAL_REAR_PASSENGER_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_shear_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_SHEAR_REAR_PASSENGER_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_extension_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_REAR_PASSENGER_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_axial_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_AXIAL_REAR_PASSENGER_CAPPING_LIMIT`
                    );
                    neck_shear_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_SHEAR_REAR_PASSENGER_CAPPING_LIMIT`
                    );
                    neck_extension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_REAR_PASSENGER_CAPPING_LIMIT`
                    );
                    break;
                case "DRIVER":
                    neck_axial_tension_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_AXIAL_SCORE`,
                        "float",
                        templ
                    );
                    neck_shear_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_SHEAR_SCORE`,
                        "float",
                        templ
                    );
                    neck_extension_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_SCORE`,
                        "float",
                        templ
                    );
                    neck_axial_tension_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_AXIAL_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_shear_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_SHEAR_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_extension_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_axial_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_AXIAL_CAPPING_LIMIT`);
                    neck_shear_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_SHEAR_CAPPING_LIMIT`);
                    neck_extension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_CAPPING_LIMIT`
                    );
                    break;
                case "FRONT_PASSENGER":
                    neck_axial_tension_passenger_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_AXIAL_PASSENGER_SCORE`,
                        "float",
                        templ
                    );
                    neck_shear_passenger_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_SHEAR_PASSENGER_SCORE`,
                        "float",
                        templ
                    );
                    neck_extension_passenger_score = get_variable_value_and_ENCAP_band_score(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_PASSENGER_SCORE`,
                        "float",
                        templ
                    );
                    neck_axial_tension_passenger_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_AXIAL_PASSENGER_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_shear_passenger_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_SHEAR_PASSENGER_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_extension_passenger_score_banded = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_PASSENGER_SCORE_ENCAP_BANDED`,
                        "float"
                    );
                    neck_axial_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_AXIAL_CAPPING_LIMIT`);
                    neck_shear_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_SHEAR_CAPPING_LIMIT`);
                    neck_extension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_CAPPING_LIMIT`
                    );
                    neck_shear_exceedence_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_SHEAR_EXCEEDENCE_CAPPING_LIMIT`
                    );
                    neck_extension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_CAPPING_LIMIT`
                    );
                    break;
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let head_score = 0;
            let neck_score = 0;
            let neck_score_passenger = 0;
            let modifier_total = 0;
            let modifier_total_pass = 0;
            let modifier_total_rear_pass = 0;
            let head_and_neck_score;
            let head_and_neck_score_rear_passenger;
            let head_and_neck_score_passenger;
            let head_and_neck_points;
            let head_and_neck_points_rear_passenger;
            let head_and_neck_points_passenger;
            let head_and_neck_score_nomod;
            let head_and_neck_score_rear_passenger_nomod;
            let head_and_neck_score_passenger_nomod;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let head_capping_limit = "";
            let neck_capping_limit = "";
            let head_neck_capping_limit = "";

            /* If we have all the required variables, calculate the final scores */
            if (true) {
                /* Head score is sum of score with modifiers.
                 * For the driver, steering wheel airbag must be present or score remains zero. */

                head_score = Math.min(head_hic_score_banded, head_three_ms_exc_score_banded);

                /* Neck score is minimum of axial, shear, and bending components */

                neck_score = Math.min(
                    neck_axial_tension_score_banded,
                    neck_shear_score_banded,
                    neck_extension_score_banded
                );
                neck_score_passenger = Math.min(
                    neck_axial_tension_passenger_score_banded,
                    neck_shear_passenger_score_banded,
                    neck_extension_passenger_score_banded
                );

                modifier_total = hb_mod + haz_ab_mod + inc_ab_mod + ab_con_mod;
                modifier_total_pass = hb_mod + haz_ab_mod + inc_ab_mod + ab_con_mod + head_dmg_mod;
                modifier_total_rear_pass = hb_mod + haz_ab_mod + inc_ab_mod + ab_con_mod + head_exc_mod;

                /* Bound the score between upper and lower limits */

                head_score = Math.max(Math.min(head_score, 100.0), 0.0);
                neck_score = Math.max(Math.min(neck_score, 100.0), 0.0);
                neck_score_passenger = Math.max(Math.min(neck_score_passenger, 100.0), 0.0);

                LogPrint(`${m} ${occ} head score = ${head_score}`);
                LogPrint(`${m} ${occ} neck score = ${neck_score}`);
                LogPrint(`${m} ${occ} neck score = ${neck_score_passenger}`);

                /* Overall score is minimum of head and neck scores */

                head_and_neck_score_rear_passenger = Math.min(head_score, neck_score) + modifier_total_rear_pass;
                head_and_neck_points_rear_passenger = (head_and_neck_score_rear_passenger / 100) * 0.625;
                head_and_neck_points_rear_passenger = Math.max(0, head_and_neck_points_rear_passenger);

                head_and_neck_score_rear_passenger_nomod = Math.min(head_score, neck_score);
                head_and_neck_score = Math.min(head_score, neck_score) + modifier_total;
                head_and_neck_points = (head_and_neck_score / 100) * 1.25;
                head_and_neck_points = Math.max(head_and_neck_points, 0);
                head_and_neck_score_nomod = Math.min(head_score, neck_score);
                head_and_neck_score_passenger = Math.min(head_score, neck_score_passenger) + modifier_total_pass;
                head_and_neck_points_passenger = (head_and_neck_score_passenger / 100) * 0.625;
                head_and_neck_points_passenger = Math.max(head_and_neck_points_passenger, 0);
                head_and_neck_score_passenger_nomod = Math.min(head_score, neck_score_passenger);
                head_and_neck_score = Math.max(Math.min(head_and_neck_score, 100.0), 0.0);
                head_and_neck_score_passenger = Math.max(Math.min(head_and_neck_score_passenger, 100.0), 0.0);
                head_and_neck_score_rear_passenger = Math.max(Math.min(head_and_neck_score_rear_passenger, 100.0), 0.0);

                const fallback = (x) => (isNaN(x) ? "Missing" : Math.max(Math.min(x, 100), 0));

                head_and_neck_score = fallback(head_and_neck_score);
                head_and_neck_score_nomod = isNaN(head_and_neck_score_nomod) ? "Missing" : head_and_neck_score_nomod;
                head_and_neck_points = isNaN(head_and_neck_points) ? "Missing" : head_and_neck_points;

                head_and_neck_score_passenger = fallback(head_and_neck_score_passenger);
                head_and_neck_score_passenger_nomod = isNaN(head_and_neck_score_passenger_nomod)
                    ? "Missing"
                    : head_and_neck_score_passenger_nomod;
                head_and_neck_points_passenger = isNaN(head_and_neck_points_passenger)
                    ? "Missing"
                    : head_and_neck_points_passenger;

                head_and_neck_score_rear_passenger = fallback(head_and_neck_score_rear_passenger);
                head_and_neck_score_rear_passenger_nomod = isNaN(head_and_neck_score_rear_passenger_nomod)
                    ? "Missing"
                    : head_and_neck_score_rear_passenger_nomod;
                head_and_neck_points_rear_passenger = isNaN(head_and_neck_points_rear_passenger)
                    ? "Missing"
                    : head_and_neck_points_rear_passenger;

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */

                if (head_hic_capping_limit == "" && head_tms_capping_limit == "") {
                    head_capping_limit = "";
                }
                if (
                    (occ == "DRIVER" &&
                        neck_axial_capping_limit == "" &&
                        neck_shear_capping_limit == "" &&
                        neck_extension_capping_limit == "") ||
                    occ == "FRONT_PASSENGER" ||
                    occ == "REAR_PASSENGER_SIDE"
                ) {
                    neck_capping_limit = "";
                }
                if (head_capping_limit == "" && neck_capping_limit == "") {
                    head_neck_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Overall scores */
            let head_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_FINAL_SCORE`,
                "Final head score",
                head_score.toString(),
                "String",
                false,
                true
            );
            let head_hic_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_HIC_SCORE`,
                " head HIC score",
                head_hic_score.toString(),
                "String",
                false,
                true
            );
            let head_three_ms_exc_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE`,
                " head three ms exe score",
                head_three_ms_exc_score.toString(),
                "String",
                false,
                true
            );
            let neck_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_NECK_FINAL_SCORE`,
                "Final neck score",
                neck_score.toString(),
                "String",
                false,
                true
            );
            let neck_score_passenger_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_NECK_FINAL_PASSENGER_SCORE`,
                "Final neck score",
                neck_score_passenger.toString(),
                "String",
                false,
                true
            );
            let head_neck_score_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_NECK_FINAL_SCORE`,
                `Final ${body_region_label} score`,
                head_and_neck_score.toString(),
                "String",
                false,
                true
            );
            let head_neck_score_rear_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_NECK_REAR_FINAL_SCORE`,
                `Final ${body_region_label} score`,
                head_and_neck_score_rear_passenger.toString(),
                "String",
                false,
                true
            );
            let head_neck_score_passenger_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_NECK_FINAL_PASSENGER_SCORE`,
                `Final ${body_region_label} score`,
                head_and_neck_score_passenger.toString(),
                "String",
                false,
                true
            );
            let head_neck_points_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_NECK_FINAL_POINTS`,
                `Final ${body_region_label} score`,
                head_and_neck_points.toString(),
                "String",
                false,
                true
            );
            let head_neck_points_rear_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_NECK_REAR_FINAL_POINTS`,
                `Final ${body_region_label} score`,
                head_and_neck_points_rear_passenger.toString(),
                "String",
                false,
                true
            );
            let head_neck_points_passenger_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_NECK_FINAL_PASSENGER_POINTS`,
                `Final ${body_region_label} score`,
                head_and_neck_points_passenger.toString(),
                "String",
                false,
                true
            );
            let head_neck_score_nomod_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_NECK_FINAL_SCORE_NOMOD`,
                `Final ${body_region_label} score`,
                head_and_neck_score_nomod.toString(),
                "String",
                false,
                true
            );
            let head_neck_score_rear_nomod_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_NECK_REAR_FINAL_SCORE_NOMOD`,
                `Final ${body_region_label} score`,
                head_and_neck_score_rear_passenger_nomod.toString(),
                "String",
                false,
                true
            );
            let head_neck_score_passenger_nomod_var = new_variable_and_new_euroNCAP_banded_score(
                templ,
                `${m}_${occ}_HEAD_NECK_FINAL_PASSENGER_SCORE_NOMOD`,
                `Final ${body_region_label} score`,
                head_and_neck_score_passenger_nomod.toString(),
                "String",
                false,
                true
            );
            let modifier_total_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_MODIFIER_TOTAL`,
                `Final ${body_region_label} modifier`,
                modifier_total.toString(),
                "String",
                false,
                true
            );
            let modifier_total_pass_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_MODIFIER_PASSENGER_TOTAL`,
                `Final ${body_region_label} modifier`,
                modifier_total_pass.toString(),
                "String",
                false,
                true
            );
            let modifier_total_rear_pass_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_MODIFIER_REAR_PASSENGER_TOTAL`,
                `Final ${body_region_label} modifier`,
                modifier_total_rear_pass.toString(),
                "String",
                false,
                true
            );

            /* Capping limits */
            let head_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_CAPPING_LIMIT`,
                "Head capping limit (*asterisk if limit exceeded; empty string otherwise)",
                head_capping_limit,
                "String",
                false,
                true
            );
            let neck_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_NECK_CAPPING_LIMIT`,
                "Neck capping limit (*asterisk if limit exceeded; empty string otherwise)",
                neck_capping_limit,
                "String",
                false,
                true
            );
            let head_neck_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_NECK_CAPPING_LIMIT`,
                "Head and neck capping limit (*asterisk if limit exceeded; empty string otherwise)",
                head_neck_capping_limit,
                "String",
                false,
                true
            );
        }
        let capping_limit_explanation_var = new Variable(
            templ,
            `${m}_HEAD_NECK_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
