/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
chest_and_abdomen_score();

/**
 * Performs the chest  score calculation for the specified models
 */
function chest_and_abdomen_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `chest and abdomen`;

    let occupants = ["DRIVER", "FRONT_PASSENGER", "REAR_DRIVER_SIDE"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Chest score and modifiers */

            /* Driver */
            let steering_wheel_contact_mod;

            /* Front passenger */
            let chest_comp_score;
            let chest_vc_score;
            let chest_comp_capping_limit;
            let chest_vc_capping_limit;

            /* Shared */
            let incorrect_airbag_mod = get_variable_value(
                status,
                `${m}_${occ}_CHEST_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`,
                "int"
            );
            let belt_load_mod = get_variable_value(status, `${m}_${occ}_CHEST_BELT_LOAD_MODIFIER`, "int");

            switch (occ) {
                case "DRIVER":
                    steering_wheel_contact_mod = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_STEERING_WHEEL_CONTACT_MODIFIER`,
                        "int"
                    );
                    chest_comp_score = get_variable_value(status, `${m}_${occ}_CHEST_COMPRESSION_SCORE`, "float");
                    chest_vc_score = get_variable_value(status, `${m}_${occ}_CHEST_VISCOUS_CRITERION_SCORE`, "float");
                    chest_comp_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_CAPPING_LIMIT`
                    );
                    chest_vc_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_CAPPING_LIMIT`
                    );
                    break;
                case "FRONT_PASSENGER":
                    chest_comp_score = get_variable_value(status, `${m}_${occ}_CHEST_COMPRESSION_SCORE`, "float");
                    chest_vc_score = get_variable_value(status, `${m}_${occ}_CHEST_VISCOUS_CRITERION_SCORE`, "float");
                    chest_comp_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_CAPPING_LIMIT`
                    );
                    chest_vc_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_CAPPING_LIMIT`
                    );
                case "REAR_DRIVER_SIDE":
                    chest_comp_score = get_variable_value(status, `${m}_${occ}_CHEST_COMPRESSION_SCORE`, "float");
                    chest_vc_score = get_variable_value(status, `${m}_${occ}_CHEST_VISCOUS_CRITERION_SCORE`, "float");
                    chest_comp_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_CAPPING_LIMIT`
                    );
                    chest_vc_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_CAPPING_LIMIT`
                    );
                    break;
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let chest_max_val = "[Not computed]";
            let chest_score_before_mods = 0;
            let chest_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let chest_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Score calculation is different for different occupants */
                switch (occ) {
                    case "DRIVER":
                        chest_score_before_mods = Math.min(chest_comp_score, chest_vc_score);
                        chest_score = Math.max(
                            0,
                            chest_score_before_mods + steering_wheel_contact_mod + incorrect_airbag_mod + belt_load_mod
                        );

                        /* Check capping limits. If any individual limits are exceeded, an asterisk is
                         * displayed for all parent body regions. */
                        if (chest_comp_capping_limit == "" && chest_vc_capping_limit == "") {
                            chest_capping_limit = "";
                        } else {
                            capping_limit_explanation = `*Capping limit exceeded`;
                        }
                    case "FRONT_PASSENGER":
                        /* Chest score is minimum of compression and viscous criterion scores, summed with modifiers */
                        chest_score_before_mods = Math.min(chest_comp_score, chest_vc_score);
                        chest_score = Math.max(0, chest_score_before_mods + incorrect_airbag_mod + belt_load_mod);

                        /* Check capping limits. If any individual limits are exceeded, an asterisk is
                         * displayed for all parent body regions. */
                        if (chest_comp_capping_limit == "" && chest_vc_capping_limit == "") {
                            chest_capping_limit = "";
                        } else {
                            capping_limit_explanation = `*Capping limit exceeded`;
                        }
                        break;
                    case "REAR_DRIVER_SIDE":
                        /* Chest score is minimum of compression and viscous criterion scores, summed with modifiers */
                        chest_score_before_mods = Math.min(chest_comp_score, chest_vc_score);
                        chest_score = Math.max(0, chest_score_before_mods + incorrect_airbag_mod + belt_load_mod);

                        /* Check capping limits. If any individual limits are exceeded, an asterisk is
                         * displayed for all parent body regions. */
                        if (chest_comp_capping_limit == "" && chest_vc_capping_limit == "") {
                            chest_capping_limit = "";
                        } else {
                            capping_limit_explanation = `*Capping limit exceeded`;
                        }
                        break;
                    default:
                        LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                        Exit();
                }

                LogPrint(`${m} ${occ} chest score = ${chest_score}`);
                LogPrint(`${m} ${occ} ${body_region_label} score = ${chest_and_abdomen_score}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Only write some variables for driver */

            let chest_score_var = new Variable(
                templ,
                `${m}_${occ}_CHEST_FINAL_SCORE`,
                "Final chest score",
                chest_score.toString(),
                "String",
                false,
                true
            );
            let chest_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_CHEST_CAPPING_LIMIT`,
                `Chest capping limit`,
                chest_capping_limit,
                "String",
                false,
                true
            );
        }
        let capping_limit_explanation_var = new Variable(
            templ,
            `${m}_CHEST_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
