summary_variables();

/* These are the summary variables needed for CNCAP SUMMARY Template otherwise the auto table won't work */
function summary_variables() {
    let templ = Template.GetCurrent();
    let working_condition_var = Variable.GetFromName(templ, "WORKING_CONDITION");

    let wc_num;

    if (working_condition_var) {
        let wc_var_val = templ.ExpandVariablesInString(working_condition_var.value);
        if (!Number.isNaN(wc_var_val)) {
            wc_num = parseInt(wc_var_val);
        }
    }

    if (!wc_num || wc_num < 1 || wc_num > 8) {
        LogError(`Invalid working condition number - must be between 1 and 8 but was: ${wc_num}`);
        return;
    }

    /* Test Input */
    if (wc_num == 1 || wc_num == 2 || wc_num == 7 || wc_num == 8) {
        new Variable(templ, "SUMMARY_TEST_INPUT", "Test input for summary template", "32 %[POLE_IMPACT]% 75");
    } else if (wc_num == 3 || wc_num == 4) {
        new Variable(templ, "SUMMARY_TEST_INPUT", "Test input for summary template", "32 %[POLE_IMPACT]% 90");
    } else if (wc_num == 5 || wc_num == 6) {
        new Variable(templ, "SUMMARY_TEST_INPUT", "Test input for summary template", "32 %[POLE_IMPACT]% 60");
    }

    /* Dummy Settings */
    if (wc_num == 1 || wc_num == 2 || wc_num == 3 || wc_num == 4 || wc_num == 5 || wc_num == 6) {
        new Variable(templ, "SUMMARY_DUMMY_SETTINGS", "Dummy settings for summary template", "WorldSID 50th");
    } else if (wc_num == 7 || wc_num == 8) {
        new Variable(templ, "SUMMARY_DUMMY_SETTINGS", "Dummy settings for summary template", "SID-IIs");
    }

    /* Seat Position */
    if (wc_num == 1 || wc_num == 3 || wc_num == 5 || wc_num == 7) {
        new Variable(templ, "SUMMARY_SEAT_POSITION", "Seat position for summary template", "%[DESIGN_LOCATION]%");
    } else if (wc_num == 2 || wc_num == 4 || wc_num == 6 || wc_num == 8) {
        new Variable(templ, "SUMMARY_SEAT_POSITION", "Seat position for summary template", "%[HIGHEST_LEVEL]%");
    }
}
