/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
pelvis_score();

function pelvis_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `pelvis`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /**Pelvis Score and Modifer */
            let pubic_sym_force_value;
            let pubic_sym_force_score;
            let pelvis_force_capping_limit;
            let pelvis_force_high_limit = null;
            let pelvis_force_low_limit = null;

            pubic_sym_force_value = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_MAX_VALUE`, "float");
            pubic_sym_force_score = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_SCORE`, "float");
            pelvis_force_capping_limit = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_CAPPING_LIMIT`);

            pelvis_force_high_limit = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_HIGH_LIMIT`, "float");
            pelvis_force_low_limit = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_LOW_LIMIT`, "float");

            /**
             * It's possible that the high and low limits variables are not present in the template. If, for some reason, the assessment couldn't be computed, then the value,
             * score, and limits variables won't be present (due to missing or invalid input).
             * If they are not present, we need to create those variables and assign them a 'Missing' value with the same variable name.
             */

            if (pelvis_force_high_limit == null) {
                let pelvis_force_high_limit_var = new Variable(
                    templ,
                    `${m}_${occ}_PELVIS_FORCE_HIGH_LIMIT`,
                    `Final ${body_region_label} score`,
                    "Missing",
                    "string",
                    false,
                    true
                );
            }

            if (pelvis_force_low_limit == null) {
                let pelvis_force_low_limit_var = new Variable(
                    templ,
                    `${m}_${occ}_PELVIS_FORCE_LOW_LIMIT`,
                    `Final ${body_region_label} score`,
                    "Missing",
                    "string",
                    false,
                    true
                );
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let pelvis_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let pelvis_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */
                if (pelvis_force_capping_limit == "") {
                    pelvis_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }

                /* Left/right score is minimum of acetabular, femur and knee scores, summed with modifiers */
                pelvis_score = Math.max(0, pubic_sym_force_score);

                LogPrint(`${m} ${occ} ${body_region_label} score = ${pelvis_score}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Overall score for each occupant is minimum of left and right scores */
            let pelvis_final_score = pelvis_score;
            let pelvis_final_score_var = new Variable(
                templ,
                `${m}_${occ}_PELVIS_FINAL_SCORE`,
                `Final ${body_region_label} score`,
                pelvis_final_score.toString(),
                "String",
                false,
                true
            );
            let pelvis_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_PELVIS_CAPPING_LIMIT`,
                `Pelvis capping limit`,
                pelvis_capping_limit,
                "String",
                false,
                true
            );
        }
        let capping_limit_explanation_var = new Variable(
            templ,
            `${m}_PELVIS_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
