overall_score();

/**
 * Performs the overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();

    for (let m of models) {
        LogPrint(`Calculating ${m} overall score...`);

        /* Create a status object to track whether REPORTER Variables are all present and valid.
         * <success> is initially true but will be set to false if anything missing or invalid. */
        let status = { success: true, missing: [], invalid: [] };

        /* Body region final scores */
        let head_score_driver = get_variable_value(status, `${m}_DRIVER_HEAD_FINAL_SCORE`, "float");
        let chest_score_driver = get_variable_value(status, `${m}_DRIVER_CHEST_FINAL_SCORE`, "float");
        let pelvis_score_driver = get_variable_value(status, `${m}_DRIVER_PELVIS_FINAL_SCORE`, "float");
        let abdomen_score_driver = get_variable_value(status, `${m}_DRIVER_ABDOMEN_FINAL_SCORE`, "float");

        /* Body region capping limits */
        let head_capping_limit = get_variable_value(status, `${m}_DRIVER_HEAD_CAPPING_LIMIT`, "string");
        let chest_capping_limit = get_variable_value(status, `${m}_DRIVER_CHEST_CAPPING_LIMIT`, "string");
        let pelvis_capping_limit = get_variable_value(status, `${m}_DRIVER_PELVIS_CAPPING_LIMIT`, "string");
        let abdomen_capping_limit = get_variable_value(status, `${m}_DRIVER_ABDOMEN_CAPPING_LIMIT`, "string");

        /* Final scores all start at zero and will remain so if any variables were missing or invalid */
        let overall_score = 0;
        let overall_capping_limit = "*";
        let final_score = 0;

        /* If we have all the required variables, calculate the final scores */
        if (status.success) {
            /* Airbag deployment patterns modifier */
            LogPrint(`Retrieving airbag deployment patterns modifier...`);
            let airbag_deployment_patterns_mod = get_variable_value(
                status,
                `${m}_AIRBAG_DEPLOYMENT_PATTERNS_MODIFIER`,
                "int"
            );
            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} airbag deployment patterns modifier`);
                airbag_deployment_patterns_mod = 0;
            }

            LogPrint(`Retrieving airbag external dimensions modifier...`);
            let airbag_ext_dimensions_mod = get_variable_value(
                status,
                `${m}_INCORRECT_AIRBAG_EXTERNAL_DIMENSIONS_MODIFIER`,
                "int"
            );
            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} airbag external dimensions modifier`);
                airbag_ext_dimensions_mod = 0;
            }

            LogPrint(`Retrieving door locking feature failure modifier...`);
            let door_locking_feature_failure = get_variable_value(
                status,
                `${m}_DOOR_LOCKING_FEATURE_FAILURE_MODIFIER`,
                "int"
            );
            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} door locking feature modifier`);
                door_locking_feature_failure = 0;
            }

            LogPrint(`Retrieving incorrect restraint release modifier...`);
            let incorrect_restraint_release = get_variable_value(
                status,
                `${m}_INCORRECT_RESTRAINT_RELEASE_MODIFIER`,
                "int"
            );
            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} incorrect restraint system modifier`);
                incorrect_restraint_release = 0;
            }

            LogPrint(`Retrieving airbag dynamic protection performance modifier...`);
            let airbag_dynamic_protection = get_variable_value(
                status,
                `${m}_AIRBAG_DYNAMIC_PROTECTION_PERFORMANCE_MODIFIER`,
                "int"
            );
            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} airbag dynamic protection performance modifier`);
                airbag_dynamic_protection = 0;
            }

            LogPrint(`Retrieving incorrect airbag deployment modifier...`);
            let incorrect_airbag_deployment = get_variable_value(
                status,
                `${m}_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`,
                "int"
            );
            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} incorrect airbag deployment modifier`);
                incorrect_airbag_deployment = 0;
            }

            LogPrint(`Retrieving seatbelt system failure modifier...`);
            let seatbelt_system_failure_mod = get_variable_value(
                status,
                `${m}_RESTRAINT_SYSTEM_TEST_FAILURE_MODIFIER`,
                "int"
            );
            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} seatbelt system failure modifier`);
                seatbelt_system_failure_mod = 0;
            }

            /* Overall occupant score is sum of body region scores. */
            overall_score =
                head_score_driver +
                chest_score_driver +
                pelvis_score_driver +
                abdomen_score_driver +
                airbag_deployment_patterns_mod +
                airbag_ext_dimensions_mod +
                door_locking_feature_failure +
                incorrect_restraint_release +
                airbag_dynamic_protection +
                incorrect_airbag_deployment +
                seatbelt_system_failure_mod;
            LogPrint(`${m} overall score = overall_score`);
            // checks that overall_score is between 0 and 16
            if (overall_score < 0.0) {
                overall_score = 0.0;
            } else if (overall_score > 16.0) {
                overall_score = 16.0;
            }

            /* Only remove the overall occupant capping limit if none of the body region
             * capping limits were exceeded. */
            if (
                head_capping_limit == "" &&
                chest_capping_limit == "" &&
                pelvis_capping_limit == "" &&
                abdomen_capping_limit == ""
            ) {
                overall_capping_limit = "";
                LogPrint(`Capping limit not applied to ${m} DRIVER.`);
                final_score = overall_score;
            } else {
                LogPrint(`Capping limit applied to ${m} DRIVER.`);
                final_score = 0;
            }
        } else {
            warn_about_missing_or_invalid_variables(status, `${m} DRIVER overall score calculation`);
        }

        let overall_score_var = new Variable(
            templ,
            `${m}_OVERALL_SCORE`,
            `Overall score`,
            overall_score.toString(),
            "String",
            false,
            true
        );

        let final_score_var = new Variable(
            templ,
            `${m}_FINAL_SCORE`,
            `Final score`,
            final_score.toString(),
            "String",
            false,
            true
        );

        let overall_capping_limit_var = new Variable(
            templ,
            `${m}_OVERALL_CAPPING_LIMIT`,
            `Overall capping limit`,
            overall_capping_limit,
            "String",
            false,
            true
        );
        let capping_limit_explanation = `*Capping limit exceeded`;
        if (overall_capping_limit == "") {
            capping_limit_explanation = "";
        }
        let capping_limit_explanation_var = new Variable(
            templ,
            `${m}_OVERALL_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
