/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
abdomen_score();

/**
 * Performs the chest and abdomen score calculation for the specified models
 */
function abdomen_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `abdomen`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Abdomen score and modifiers */
            let abdomen_comp_top_max_value;
            let abdomen_comp_bottom_max_value;
            let abdomen_comp_top_max_score;
            let abdomen_comp_bottom_max_score;
            let abdomen_vc_top_max_val;
            let abdomen_vc_bottom_max_val;
            let abdomen_vc_top_max_rating;
            let abdomen_vc_bottom_max_rating;
            let abdomen_comp_01_high_limit;
            let abdomen_comp_01_low_limit;
            let abdomen_comp_02_high_limit;
            let abdomen_comp_02_low_limit;

            let abdomen_comp_max_01_capping_limit = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_CAPPING_LIMIT`
            );
            let abdomen_comp_max_02_capping_limit = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_CAPPING_LIMIT`
            );

            abdomen_comp_top_max_value = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_VALUE`,
                "float"
            );
            abdomen_comp_bottom_max_value = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_VALUE`,
                "float"
            );
            abdomen_comp_top_max_score = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_SCORE`,
                "float"
            );
            abdomen_comp_bottom_max_score = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_SCORE`,
                "float"
            );
            abdomen_vc_top_max_val = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_UPPER_MAX_VALUE`,
                "float"
            );
            abdomen_vc_bottom_max_val = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_LOWER_MAX_VALUE`,
                "float"
            );
            abdomen_vc_top_max_rating = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_UPPER_MAX_RATING`,
                "string"
            );
            abdomen_vc_bottom_max_rating = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_LOWER_MAX_RATING`,
                "string"
            );

            abdomen_comp_01_high_limit = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_HIGH_LIMIT`,
                "float"
            );
            abdomen_comp_01_low_limit = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_LOW_LIMIT`,
                "float"
            );
            abdomen_comp_02_high_limit = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_HIGH_LIMIT`,
                "float"
            );
            abdomen_comp_02_low_limit = get_variable_value(
                status,
                `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_LOW_LIMIT`,
                "float"
            );

            /**
             * It's possible that the high and low limits variables are not present in the template. If, for some reason, the assessment couldn't be computed, then the value,
             * score, and limits variables won't be present (due to missing or invalid input).
             * If they are not present, we need to create those variables and assign them a 'Missing' value with the same variable name.
             */

            if (abdomen_comp_01_high_limit == null) {
                let abdomen_comp_01_high_limit_var = new Variable(
                    templ,
                    `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_HIGH_LIMIT`,
                    `Final ${body_region_label} score`,
                    "Missing",
                    "string",
                    false,
                    true
                );
            }
            if (abdomen_comp_01_low_limit == null) {
                let abdomen_comp_01_low_limit_var = new Variable(
                    templ,
                    `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_01_LOW_LIMIT`,
                    `Final ${body_region_label} score`,
                    "Missing",
                    "string",
                    false,
                    true
                );
            }
            if (abdomen_comp_02_high_limit == null) {
                let abdomen_comp_02_high_limit_var = new Variable(
                    templ,
                    `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_HIGH_LIMIT`,
                    `Final ${body_region_label} score`,
                    "Missing",
                    "string",
                    false,
                    true
                );
            }
            if (abdomen_comp_02_low_limit == null) {
                let abdomen_comp_02_low_limit_var = new Variable(
                    templ,
                    `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_02_LOW_LIMIT`,
                    `Final ${body_region_label} score`,
                    "Missing",
                    "string",
                    false,
                    true
                );
            }

            let abdomen_vc_mod =
                abdomen_vc_top_max_rating == "Pass" && abdomen_vc_bottom_max_rating == "Pass" ? "Pass" : "Fail";
            let abdomen_vc_var = new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_VISCOUS_CRITERION_MODIFIER`,
                "Abdomen VC Modifier",
                abdomen_vc_mod.toString(),
                "String",
                false,
                true
            );

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let abdomen_score = 0;
            let abdomen_score_before_mods = 0;

            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let abdomen_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Score calculation is different for different occupants */
                /* Abdomen score is minimum of top and bottom scores */

                abdomen_score_before_mods = Math.min(abdomen_comp_top_max_score, abdomen_comp_bottom_max_score);

                if (abdomen_vc_top_max_rating == "Pass" && abdomen_vc_bottom_max_rating == "Pass") {
                    abdomen_score = abdomen_score_before_mods;
                } else {
                    abdomen_score = 0;
                }

                /* Only report abdomen score for driver */
                LogPrint(`${m} ${occ} abdomen score = ${abdomen_score}`);

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */
                if (abdomen_comp_max_01_capping_limit == "" && abdomen_comp_max_02_capping_limit == "") {
                    abdomen_capping_limit = "";
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            let abdomen_score_var = new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_FINAL_SCORE`,
                "Final abdomen score",
                abdomen_score.toString(),
                "String",
                false,
                true
            );
            let abdomen_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_ABDOMEN_CAPPING_LIMIT`,
                `Abdomen capping limit`,
                abdomen_capping_limit,
                "String",
                false,
                true
            );

            let capping_limit_explanation_var = new Variable(
                templ,
                `${m}_ABDOMEN_CAPPING_LIMIT_EXPLANATION`,
                `Capping limit explanation`,
                capping_limit_explanation,
                "String",
                false,
                true
            );
        }
    }
}
