/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
head_and_neck_score();

/**
 * Performs the head and neck score calculation for the specified models
 */
function head_and_neck_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `head and neck`;

    let occupants = ["DRIVER", "FRONT_PASSENGER", "REAR_DRIVER_SIDE", "REAR_PASSENGER_SIDE"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        let steering_column_intrusion_min_score = 0;
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Head score */
            let head_hic_score;
            let head_hic_capping_limit;
            let head_tms_score;
            let head_tms_capping_limit;
            switch (occ) {
                case "DRIVER":
                case "FRONT_PASSENGER":
                    head_hic_score = get_variable_value(status, `${m}_${occ}_HEAD_HIC_SCORE`, "float");
                    head_hic_capping_limit = get_variable_value(status, `${m}_${occ}_HEAD_HIC_CAPPING_LIMIT`);
                    head_tms_score = get_variable_value(status, `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_SCORE`, "float");
                    head_tms_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_CAPPING_LIMIT`
                    );
                    break;
                case "REAR_DRIVER_SIDE":
                    head_hic_score = get_variable_value(status, `${m}_${occ}_HEAD_HIC_REAR_PASSENGER_SCORE`, "float");
                    head_hic_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_HEAD_HIC_REAR_PASSENGER_CAPPING_LIMIT`
                    );
                    head_tms_score = get_variable_value(
                        status,
                        `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_REAR_PASSENGER_SCORE`,
                        "float"
                    );
                    head_tms_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_REAR_PASSENGER_CAPPING_LIMIT`
                    );
                    break;
                case "REAR_PASSENGER_SIDE":
                    head_hic_score = get_variable_value(status, `${m}_${occ}_HEAD_HIC_REAR_CHILD_SCORE`, "float");
                    head_tms_score = get_variable_value(
                        status,
                        `${m}_${occ}_HEAD_THREE_MS_EXCEEDENCE_REAR_CHILD_SCORE`,
                        "float"
                    );
                    break;
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }

            /* head modifiers */
            let haz_ab_mod;
            let inc_ab_mod;
            let ab_con_mod;
            switch (occ) {
                case "DRIVER":
                case "FRONT_PASSENGER":
                case "REAR_DRIVER_SIDE":
                    haz_ab_mod = get_variable_value(
                        status,
                        `${m}_${occ}_HEAD_HAZARDOUS_AIRBAG_DEPLOYMENT_MODIFIER`,
                        "float"
                    );
                    inc_ab_mod = get_variable_value(
                        status,
                        `${m}_${occ}_HEAD_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`,
                        "float"
                    );
                    ab_con_mod = get_variable_value(status, `${m}_${occ}_HEAD_AIRBAG_CONTACT_MODIFIER`, "float");
                    break;
            }

            /*Driver */
            let steering_column_intrusion_x_score;
            let steering_column_intrusion_y_score;
            let steering_column_intrusion_z_score;
            if (occ == "DRIVER") {
                steering_column_intrusion_x_score = get_variable_value(
                    status,
                    `${m}_STRUCTURE_STEERING_COLUMN_FORE_AFT_INTRUSION_SCORE`,
                    "float"
                );
                steering_column_intrusion_y_score = get_variable_value(
                    status,
                    `${m}_STRUCTURE_STEERING_COLUMN_LATERAL_INTRUSION_SCORE`,
                    "float"
                );
                steering_column_intrusion_z_score = get_variable_value(
                    status,
                    `${m}_STRUCTURE_STEERING_COLUMN_VERTICAL_INTRUSION_SCORE`,
                    "float"
                );
            }

            /* Rear Driver Side */
            let rear_driver_side_head_front_seat_displacement = 0;
            if (occ == "REAR_DRIVER_SIDE") {
                rear_driver_side_head_front_seat_displacement = get_variable_value(
                    status,
                    `${m}_${occ}_HEAD_FRONT_SEAT_DISPLACEMENT_MODIFIER`,
                    "float"
                );
            }

            /* Secondary impact */
            let secondary_impact;
            switch (occ) {
                case "REAR_DRIVER_SIDE":
                case "REAR_PASSENGER_SIDE":
                    secondary_impact = get_variable_value(status, `${m}_${occ}_SECONDARY_IMPACT_MODIFIER`, "string");
            }

            /* Neck score */
            let neck_axial_tension_score;
            let neck_shear_score;
            let neck_extension_score;
            let neck_axial_tension_capping_limit;
            let neck_shear_capping_limit;
            let neck_extension_capping_limit;

            switch (occ) {
                case "DRIVER":
                    neck_axial_tension_score = get_variable_value(status, `${m}_${occ}_NECK_AXIAL_SCORE`, "float");
                    neck_shear_score = get_variable_value(status, `${m}_${occ}_NECK_SHEAR_SCORE`, "float");
                    neck_extension_score = get_variable_value(status, `${m}_${occ}_NECK_EXTENSION_SCORE`, "float");
                    neck_axial_tension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_AXIAL_CAPPING_LIMIT`
                    );
                    neck_shear_capping_limit = get_variable_value(status, `${m}_${occ}_NECK_SHEAR_CAPPING_LIMIT`);
                    neck_extension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_CAPPING_LIMIT`
                    );
                    break;
                case "FRONT_PASSENGER":
                    neck_axial_tension_score = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_AXIAL_PASSENGER_SCORE`,
                        "float"
                    );
                    neck_shear_score = get_variable_value(status, `${m}_${occ}_NECK_SHEAR_PASSENGER_SCORE`, "float");
                    neck_extension_score = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_PASSENGER_SCORE`,
                        "float"
                    );
                    neck_axial_tension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_AXIAL_PASSENGER_CAPPING_LIMIT`
                    );
                    neck_shear_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_SHEAR_PASSENGER_CAPPING_LIMIT`
                    );
                    neck_extension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_PASSENGER_CAPPING_LIMIT`
                    );
                    break;
                case "REAR_DRIVER_SIDE":
                    neck_axial_tension_score = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_AXIAL_REAR_PASSENGER_SCORE`,
                        "float"
                    );
                    neck_shear_score = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_SHEAR_REAR_PASSENGER_SCORE`,
                        "float"
                    );
                    neck_extension_score = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_REAR_PASSENGER_SCORE`,
                        "float"
                    );
                    neck_axial_tension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_AXIAL_REAR_PASSENGER_CAPPING_LIMIT`
                    );
                    neck_shear_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_SHEAR_REAR_PASSENGER_CAPPING_LIMIT`
                    );
                    neck_extension_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_EXTENSION_REAR_PASSENGER_CAPPING_LIMIT`
                    );
                    break;
                case "REAR_PASSENGER_SIDE":
                    neck_axial_tension_score = get_variable_value(
                        status,
                        `${m}_${occ}_NECK_AXIAL_REAR_CHILD_SCORE`,
                        "float"
                    );
                    break;
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let head_score = 0;
            let neck_score = 0;
            let head_and_neck_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let head_capping_limit = "*";
            let neck_capping_limit = "*";
            let head_neck_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Head score is sum of score with modifiers */
                /* Neck score is minimum of axial, shear, and bending components */
                /* Only tension is calculated for rear driver side if there is no secondary impact and rear passenger side */
                switch (occ) {
                    case "DRIVER":
                        steering_column_intrusion_min_score = Math.min(
                            steering_column_intrusion_x_score,
                            steering_column_intrusion_y_score,
                            steering_column_intrusion_z_score
                        );
                        head_score =
                            Math.min(head_hic_score, head_tms_score) +
                            haz_ab_mod +
                            inc_ab_mod +
                            ab_con_mod +
                            steering_column_intrusion_min_score;
                        neck_score = Math.min(neck_axial_tension_score, neck_shear_score, neck_extension_score);
                        break;
                    case "FRONT_PASSENGER":
                        head_score = Math.min(head_hic_score, head_tms_score) + haz_ab_mod + inc_ab_mod + ab_con_mod;
                        neck_score = Math.min(neck_axial_tension_score, neck_shear_score, neck_extension_score);
                        break;
                    case "REAR_DRIVER_SIDE":
                        if (secondary_impact == "No") {
                            head_score =
                                head_tms_score +
                                haz_ab_mod +
                                inc_ab_mod +
                                ab_con_mod +
                                rear_driver_side_head_front_seat_displacement;
                            neck_score = neck_axial_tension_score;
                        } else {
                            head_score =
                                Math.min(head_hic_score, head_tms_score) +
                                haz_ab_mod +
                                inc_ab_mod +
                                ab_con_mod +
                                rear_driver_side_head_front_seat_displacement;
                            neck_score = Math.min(neck_axial_tension_score, neck_shear_score, neck_extension_score);
                        }
                        break;
                    case "REAR_PASSENGER_SIDE":
                        if (secondary_impact == "No") {
                            head_score = head_tms_score;
                        } else {
                            head_score = Math.min(head_hic_score, head_tms_score);
                        }
                        neck_score = neck_axial_tension_score;
                        break;
                }

                /* Bound the score between upper and lower limits */
                if (occ == "REAR_DRIVER_SIDE") {
                    head_score = Math.max(Math.min(head_score, 2.0), 0.0);
                    neck_score = Math.max(Math.min(neck_score, 2.0), 0.0);
                } else if (occ == "REAR_PASSENGER_SIDE") {
                    head_score = Math.max(Math.min(head_score, 2.0), 0.0);
                    neck_score = Math.max(Math.min(neck_score, 1.0), 0.0);
                } else {
                    head_score = Math.max(Math.min(head_score, 4.0), 0.0);
                    neck_score = Math.max(Math.min(neck_score, 4.0), 0.0);
                }

                LogPrint(`${m} ${occ} head score = ${head_score}`);
                LogPrint(`${m} ${occ} neck score = ${neck_score}`);

                if (occ == "REAR_PASSENGER_SIDE") {
                    /* For rear passenger side, Overall score is summary of head and neck scores */
                    head_and_neck_score = head_score + neck_score;
                } else {
                    /* Overall score is minimum of head and neck scores */
                    head_and_neck_score = Math.min(head_score, neck_score);
                }

                /* Check capping limits. If any individual limits are exceeded, an asterisk is
                 * displayed for all parent body regions. */
                switch (occ) {
                    case "DRIVER":
                    case "FRONT_PASSENGER":
                        if (head_hic_capping_limit == "" && head_tms_capping_limit == "") {
                            head_capping_limit = "";
                        }
                        if (
                            neck_axial_tension_capping_limit == "" &&
                            neck_shear_capping_limit == "" &&
                            neck_extension_capping_limit == ""
                        ) {
                            neck_capping_limit = "";
                        }
                        break;
                    case "REAR_DRIVER_SIDE":
                        if (secondary_impact == "No") {
                            if (head_tms_capping_limit == "") {
                                head_capping_limit = "";
                            }
                            if (neck_axial_tension_capping_limit == "") {
                                neck_capping_limit = "";
                            }
                        } else {
                            if (head_hic_capping_limit == "" && head_tms_capping_limit == "") {
                                head_capping_limit = "";
                            }
                            if (
                                neck_axial_tension_capping_limit == "" &&
                                neck_shear_capping_limit == "" &&
                                neck_extension_capping_limit == ""
                            ) {
                                neck_capping_limit = "";
                            }
                        }
                        break;
                }

                switch (occ) {
                    case "DRIVER":
                    case "FRONT_PASSENGER":
                    case "REAR_DRIVER_SIDE":
                        if (head_capping_limit == "" && neck_capping_limit == "") {
                            head_neck_capping_limit = "";
                        } else {
                            capping_limit_explanation = `*Capping limit exceeded`;
                        }
                        break;
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }
            /* Overall scores */
            let head_score_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_FINAL_SCORE`,
                "Final head score",
                head_score.toString(),
                "String",
                false,
                true
            );
            let neck_score_var = new Variable(
                templ,
                `${m}_${occ}_NECK_FINAL_SCORE`,
                "Final neck score",
                neck_score.toString(),
                "String",
                false,
                true
            );
            let head_neck_score_var = new Variable(
                templ,
                `${m}_${occ}_HEAD_NECK_FINAL_SCORE`,
                `Final ${body_region_label} score`,
                head_and_neck_score.toString(),
                "String",
                false,
                true
            );
            if (occ == "DRIVER" || "FRONT_PASSENGER" || "REAR_PASSENGER_SIDE") {
                /* Capping limits */
                let head_capping_limit_var = new Variable(
                    templ,
                    `${m}_${occ}_HEAD_CAPPING_LIMIT`,
                    "Head capping limit (*asterisk if limit exceeded; empty string otherwise)",
                    head_capping_limit,
                    "String",
                    false,
                    true
                );
                let neck_capping_limit_var = new Variable(
                    templ,
                    `${m}_${occ}_NECK_CAPPING_LIMIT`,
                    "Neck capping limit (*asterisk if limit exceeded; empty string otherwise)",
                    neck_capping_limit,
                    "String",
                    false,
                    true
                );
                let head_neck_capping_limit_var = new Variable(
                    templ,
                    `${m}_${occ}_HEAD_NECK_CAPPING_LIMIT`,
                    "Head and neck capping limit (*asterisk if limit exceeded; empty string otherwise)",
                    head_neck_capping_limit,
                    "String",
                    false,
                    true
                );
            }
            let steering_column_intrusion_min_score_var = new Variable(
                templ,
                `${m}_STRUCTURE_STEERING_COLUMN_INTRUSION_MIN_SCORE`,
                "steering column intrusion min score",
                steering_column_intrusion_min_score.toString(),
                "String",
                false,
                true
            );
            let capping_limit_explanation_var = new Variable(
                templ,
                `${m}_HEAD_NECK_CAPPING_LIMIT_EXPLANATION`,
                `Capping limit explanation`,
                capping_limit_explanation,
                "String",
                false,
                true
            );
        }
    }
}
