/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
chest_and_abdomen_score();

/**
 * Performs the chest and abdomen score calculation for the specified models
 */
function chest_and_abdomen_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `chest and abdomen`;

    let occupants = ["DRIVER"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
      
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };


            /* Driver */
            let abdomen_left_max_val;
            let abdomen_right_max_val;
           
            let chest_left_upper_val;
            let chest_left_lower_val;
            let chest_right_upper_val;
            let chest_right_lower_val;
          

            switch (occ) {
                case "DRIVER":
                    abdomen_left_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_LEFT_MAX_VALUE`,
                        "float"
                    );
                    abdomen_right_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_RIGHT_MAX_VALUE`,
                        "float"
                    );
                    chest_left_upper_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_LEFT_UPPER_VALUE`,
                        "float"
                    );
                    chest_left_lower_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_LEFT_LOWER_VALUE`,
                        "float"
                    );
                    chest_right_upper_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_RIGHT_UPPER_VALUE`,
                        "float"
                    );
                    chest_right_lower_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_RIGHT_LOWER_VALUE`,
                        "float"
                    );       
                  
                    break;
            
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let abdomen_max_val = "[Not computed]";
         
            let chest_max_val = "[Not computed]";
       
            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Score calculation is different for different occupants */
                switch (occ) {
                    case "DRIVER":
                        /* We calculate the maximum of the left and right values so we can display it in the table */
                        abdomen_max_val = Math.max(abdomen_left_max_val, abdomen_right_max_val).toString();

                        /* We calculate the maximum of the left and right upper/lower values so we can display it in the table */
                        chest_max_val = Math.max(
                            chest_left_upper_val,
                            chest_left_lower_val,
                            chest_right_upper_val,
                            chest_right_lower_val
                        ).toString();
                      
                        break;
                        
                    default:
                        LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                        Exit();
                }

            } else {
               warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Only write some variables for driver */
            if (occ == "DRIVER") {
                let abdomen_max_val_var = new Variable(
                    templ,
                    `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_VALUE`,
                    "Maximum of left and right abdomen compression values",
                    abdomen_max_val,
                    "String",
                    false,
                    true
                );
                let chest_max_val_var = new Variable(
                    templ,
                    `${m}_${occ}_CHEST_COMPRESSION_MAX_VALUE`,
                    "Maximum of left and right upper/lower compression values",
                    chest_max_val,
                    "String",
                    false,
                    true
                );
            }      
            
        }
        
    }
}
