/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
chest_and_abdomen_score();

/**
 * Performs the chest and abdomen score calculation for the specified models
 */
function chest_and_abdomen_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `chest and abdomen`;

    let occupants = ["DRIVER", "FRONT_PASSENGER", "REAR_DRIVER_SIDE", "REAR_PASSENGER_SIDE"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Chest score and modifiers */

            /* Driver */
            let abdomen_left_max_val;
            let abdomen_right_max_val;
            let abdomen_left_score;
            let abdomen_right_score;
            let chest_left_upper_val;
            let chest_left_lower_val;
            let chest_right_upper_val;
            let chest_right_lower_val;
            let chest_left_upper_score;
            let chest_left_lower_score;
            let chest_right_upper_score;
            let chest_right_lower_score;
            let chest_left_upper_capping_limit;
            let chest_left_lower_capping_limit;
            let chest_right_upper_capping_limit;
            let chest_right_lower_capping_limit;
            let a_pillar_score;
            let unstable_compartment_mod;
            let steering_wheel_contact_mod;

            /* Both Fronts */
            let incorrect_airbag_mod;

            /* Both Passengers (Front and Rear) */
            let chest_comp_score;
            let chest_vc_score;
            let chest_comp_capping_limit;
            let chest_vc_capping_limit;

            /* Rear Passenger side */
            let chest_tms_score;
            let abdomen_pressure_score;
            let abdomen_modifier;

            /* Shared */
            let belt_load_mod;
            let incorrect_belt_position;

            switch (occ) {
                case "DRIVER":
                    abdomen_left_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_LEFT_MAX_VALUE`,
                        "float"
                    );
                    abdomen_right_max_val = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_RIGHT_MAX_VALUE`,
                        "float"
                    );
                    abdomen_left_score = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_LEFT_SCORE`,
                        "float"
                    );
                    abdomen_right_score = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_COMPRESSION_RIGHT_SCORE`,
                        "float"
                    );
                    chest_left_upper_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_LEFT_UPPER_VALUE`,
                        "float"
                    );
                    chest_left_lower_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_LEFT_LOWER_VALUE`,
                        "float"
                    );
                    chest_right_upper_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_RIGHT_UPPER_VALUE`,
                        "float"
                    );
                    chest_right_lower_val = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_RIGHT_LOWER_VALUE`,
                        "float"
                    );
                    chest_left_upper_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_LEFT_UPPER_SCORE`,
                        "float"
                    );
                    chest_left_lower_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_LEFT_LOWER_SCORE`,
                        "float"
                    );
                    chest_right_upper_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_RIGHT_UPPER_SCORE`,
                        "float"
                    );
                    chest_right_lower_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_RIGHT_LOWER_SCORE`,
                        "float"
                    );
                    chest_left_upper_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_LEFT_UPPER_CAPPING_LIMIT`
                    );
                    chest_left_lower_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_LEFT_LOWER_CAPPING_LIMIT`
                    );
                    chest_right_upper_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_RIGHT_UPPER_CAPPING_LIMIT`
                    );
                    chest_right_lower_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_RIGHT_LOWER_CAPPING_LIMIT`
                    );
                    a_pillar_score = get_variable_value(
                        status,
                        `${m}_STRUCTURE_A_PILLAR_FORE_AFT_INTRUSION_SCORE`,
                        "float"
                    );
                    unstable_compartment_mod = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_UNSTABLE_PASSENGER_COMPARTMENT_MODIFIER`,
                        "float"
                    );
                    steering_wheel_contact_mod = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_STEERING_WHEEL_CONTACT_MODIFIER`,
                        "float"
                    );
                    incorrect_airbag_mod = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`,
                        "float"
                    );
                    belt_load_mod = get_variable_value(
                        status,
                        `${m}_${occ}_SHOULDER_BELT_B3_SHOULDER_BELT_FORCE_SCORE`,
                        "float"
                    );
                    break;
                case "FRONT_PASSENGER":
                    chest_comp_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_PASSENGER_SCORE`,
                        "float"
                    );
                    chest_vc_score = get_variable_value(status, `${m}_${occ}_CHEST_VISCOUS_CRITERION_SCORE`, "float");
                    chest_comp_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_PASSENGER_CAPPING_LIMIT`
                    );
                    chest_vc_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_CAPPING_LIMIT`
                    );
                    incorrect_airbag_mod = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`,
                        "float"
                    );
                    belt_load_mod = get_variable_value(
                        status,
                        `${m}_${occ}_SHOULDER_BELT_B3_SHOULDER_BELT_FORCE_SCORE`,
                        "float"
                    );
                    incorrect_belt_position = get_variable_value(
                        status,
                        `${m}_${occ}_SEATBELT_WEARING_POSITION_MODIFIER`,
                        "float"
                    );
                    break;
                case "REAR_DRIVER_SIDE":
                    chest_comp_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_REAR_PASSENGER_SCORE`,
                        "float"
                    );
                    chest_vc_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_REAR_PASSENGER_SCORE`,
                        "float"
                    );
                    chest_comp_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_COMPRESSION_REAR_PASSENGER_CAPPING_LIMIT`
                    );
                    chest_vc_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_VISCOUS_CRITERION_REAR_PASSENGER_CAPPING_LIMIT`
                    );
                    belt_load_mod = get_variable_value(
                        status,
                        `${m}_${occ}_SHOULDER_BELT_B3_SHOULDER_BELT_FORCE_REAR_PASSENGER_SCORE`,
                        "float"
                    );
                    incorrect_belt_position = get_variable_value(
                        status,
                        `${m}_${occ}_SEATBELT_WEARING_POSITION_MODIFIER`,
                        "float"
                    );
                    abdomen_modifier = get_variable_value(status, `${m}_${occ}_SUBMARINE_MODIFIER`, "int");
                    break;
                case "REAR_PASSENGER_SIDE":
                    chest_tms_score = get_variable_value(
                        status,
                        `${m}_${occ}_CHEST_THREE_MS_EXCEEDENCE_SCORE`,
                        "float"
                    );
                    abdomen_pressure_score = get_variable_value(
                        status,
                        `${m}_${occ}_ABDOMEN_PRESSURE_REAR_CHILD_SCORE`,
                        "float"
                    );
                    break;
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }

            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let abdomen_max_val = "[Not computed]";
            let abdomen_score = 0;
            let chest_max_val = "[Not computed]";
            let chest_score_before_mods = 0;
            let chest_score = 0;
            let chest_and_abdomen_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let chest_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Score calculation is different for different occupants */
                switch (occ) {
                    case "DRIVER":
                        /* We calculate the maximum of the left and right values so we can display it in the table */
                        abdomen_max_val = Math.max(abdomen_left_max_val, abdomen_right_max_val).toString();

                        /* Abdomen score is minimum of left and right scores */
                        abdomen_score = Math.min(abdomen_left_score, abdomen_right_score);

                        /* We calculate the maximum of the left and right upper/lower values so we can display it in the table */
                        chest_max_val = Math.max(
                            chest_left_upper_val,
                            chest_left_lower_val,
                            chest_right_upper_val,
                            chest_right_lower_val
                        ).toString();

                        /* Chest score is minimum of left and right scores, summed with modifiers */
                        chest_score_before_mods = Math.min(
                            chest_left_upper_score,
                            chest_left_lower_score,
                            chest_right_upper_score,
                            chest_right_lower_score
                        );

                        /* Overall occupant chest and abdomen score is minimum of individual chest and abdomen scores */
                        chest_and_abdomen_score = Math.max(0,
                            Math.min(abdomen_score, chest_score_before_mods) +
                            a_pillar_score +
                            unstable_compartment_mod +
                            steering_wheel_contact_mod +
                            incorrect_airbag_mod +
                            belt_load_mod );

                        /* Only report abdomen score for driver */
                        LogPrint(`${m} ${occ} abdomen score = ${abdomen_score}`);

                        /* Check capping limits. If any individual limits are exceeded, an asterisk is
                         * displayed for all parent body regions. */
                        if (
                            chest_left_upper_capping_limit == "" &&
                            chest_left_lower_capping_limit == "" &&
                            chest_right_upper_capping_limit == "" &&
                            chest_right_lower_capping_limit == ""
                        ) {
                            chest_capping_limit = "";
                        } else {
                            capping_limit_explanation = `*Capping limit exceeded`;
                        }
                        break;
                    case "FRONT_PASSENGER":
                        /* Chest score is minimum of compression and viscous criterion scores, summed with modifiers */
                        chest_score_before_mods = Math.min(chest_comp_score, chest_vc_score);
                        chest_score = Math.max(0, chest_score_before_mods + incorrect_airbag_mod + belt_load_mod + incorrect_belt_position);
                        abdomen_score = 0;
                        chest_and_abdomen_score = chest_score;

                        /* Check capping limits. If any individual limits are exceeded, an asterisk is
                         * displayed for all parent body regions. */
                        if (chest_comp_capping_limit == "" && chest_vc_capping_limit == "") {
                            chest_capping_limit = "";
                        } else {
                            capping_limit_explanation = `*Capping limit exceeded`;
                        }
                        break;
                    case "REAR_DRIVER_SIDE":
                        /* Chest score is minimum of compression and viscous criterion scores, summed with modifiers */
                        chest_score_before_mods = Math.min(chest_comp_score, chest_vc_score);
                        chest_score = Math.max(0, chest_score_before_mods + belt_load_mod + incorrect_belt_position);
                        abdomen_score = abdomen_modifier;
                        chest_and_abdomen_score = chest_score + abdomen_score;

                        /* Check capping limits. If any individual limits are exceeded, an asterisk is
                         * displayed for all parent body regions. */
                        if (chest_comp_capping_limit == "" && chest_vc_capping_limit == "") {
                            chest_capping_limit = "";
                        } else {
                            capping_limit_explanation = `*Capping limit exceeded`;
                        }
                        break;

                    case "REAR_PASSENGER_SIDE":
                        chest_score = chest_tms_score;
                        abdomen_score = abdomen_pressure_score;
                        chest_and_abdomen_score = chest_score + abdomen_score;
                        break;
                        
                    default:
                        LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                        Exit();
                }

                LogPrint(`${m} ${occ} chest score = ${chest_score}`);
                LogPrint(`${m} ${occ} ${body_region_label} score = ${chest_and_abdomen_score}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }

            /* Only write some variables for driver */
            if (occ == "DRIVER") {
                let abdomen_max_val_var = new Variable(
                    templ,
                    `${m}_${occ}_ABDOMEN_COMPRESSION_MAX_VALUE`,
                    "Maximum of left and right abdomen compression values",
                    abdomen_max_val,
                    "String",
                    false,
                    true
                );
                let chest_max_val_var = new Variable(
                    templ,
                    `${m}_${occ}_CHEST_COMPRESSION_MAX_VALUE`,
                    "Maximum of left and right upper/lower compression values",
                    chest_max_val,
                    "String",
                    false,
                    true
                );
                let chest_comp_score_var = new Variable(
                    templ,
                    `${m}_${occ}_CHEST_COMPRESSION_SCORE`,
                    "Minimum of left and right upper/lower compression scores",
                    chest_score_before_mods.toString(),
                    "String",
                    false,
                    true
                );
            } else {
                let chest_score_var = new Variable(
                    templ,
                    `${m}_${occ}_CHEST_FINAL_SCORE`,
                    "Final chest score",
                    chest_score.toString(),
                    "String",
                    false,
                    true
                );
            }
             
            let abdomen_score_var = new Variable(
                    templ,
                    `${m}_${occ}_ABDOMEN_FINAL_SCORE`,
                    "Final abdomen score",
                    abdomen_score.toString(),
                    "String",
                    false,
                    true
                );  
            let chest_and_abdomen_score_var = new Variable(
                templ,
                `${m}_${occ}_CHEST_ABDOMEN_FINAL_SCORE`,
                `Final ${body_region_label} score`,
                chest_and_abdomen_score.toString(),
                "String",
                false,
                true
            );
            let chest_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_CHEST_CAPPING_LIMIT`,
                `Chest capping limit`,
                chest_capping_limit,
                "String",
                false,
                true
            );
        }
        let capping_limit_explanation_var = new Variable(
            templ,
            `${m}_CHEST_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
