/* This script is to replace show the "missing_data.png" if there is no valid image to show in imgae item,
    and to avoid to errors */
reporter_show_missing_data_image();

function reporter_show_missing_data_image() {
    const templ = Template.GetCurrent();
    /* Loop through all pages to find relevant image file items */
    const pages = templ.GetAllPages();
    const template_dir = templ.GetVariableValue("TEMPLATE_DIR");
    const output_dir = get_expanded_variable_value(templ, "OUTPUT_DIR");
    const image_items = [];

    // Loop through all pages and all items to find any missing image files
    for (let p = 0; p < pages.length; p++) {
        const items = pages[p].GetAllItems();
        for (const item of items) {
            if (
                item.type == Item.IMAGE_FILE &&
                item.file.includes(`%OUTPUT_DIR%`) &&
                !File.Exists(item.file.replace(`%OUTPUT_DIR%`, output_dir))
            ) {
                image_items.push(item);
            }
        }
    }
    // Replace missing video and image files with missing_data.mp4 or .png
    for (const item of image_items) {
        if (item.file.toLowerCase().endsWith(`.mp4`)) {
            const missing_data_movie_path = template_dir + `/../../scripts/vtc_videos/images/MissingData.mp4`;
            const copy_file = File.Copy(missing_data_movie_path, item.file.replace(`%OUTPUT_DIR%`, output_dir));
        } else {
            const missing_data_image_path = template_dir + `/../../scripts/modules/missing_data.png`;
            const copy_file = File.Copy(missing_data_image_path, item.file.replace(`%OUTPUT_DIR%`, output_dir));
        }
        generate_specific_item(item);
    }

    /**
     * @param {Item} item
     */
    function generate_specific_item(item) {
        const active = item.active;
        item.active = true;
        item.Generate();
        item.active = active;
    }
}
