/* This "installer" script points Oasys programs to this Workflows bundle by
 * setting the preferences:
 *
 *     oasys*workflow_definitions_directory: <path/to/this/Workflows/bundle>
 *     oasys*workflow_only_user_specified_directory: TRUE
 */

/* Determine the script directory from the arguments array. Assume workflows directory is in same
 * directory as this installer script. */
let script_dir = arguments[0].substring(
    0,
    Math.max(arguments[0].lastIndexOf("/"), arguments[0].lastIndexOf("\\"))
);
let workflows_dir = script_dir + "/workflows";

Window.Theme(Window.THEME_CURRENT);

let result = setPrefs(workflows_dir);
if (result == false) {
    let question = Window.Question(
        "Workflows Bundle Installer",
        "Workflows bundle not found. Would you like to manually select your preferred Workflows directory?",
        Window.CANCEL | Window.YES
    );
    if (question == Window.YES) {
        workflows_dir = Window.GetDirectory();
        if (workflows_dir == null) {
            Window.Error(
                "Workflows Bundle Installer",
                "Workflows preference not set. Please consult the README file provided with the installation."
            );
            Exit();
        }
        let attempt2 = setPrefs(workflows_dir);
        if (attempt2 == false) {
            Window.Error(
                "Workflows Bundle Installer",
                "Workflows preference not set. Please consult the README file provided with the installation."
            );
            Exit();
        }
    }
}
Exit();

function setPrefs(workflows_dir) {
    if (File.IsDirectory(workflows_dir)) {
        let success_1 = SetPreferenceValue(
            "All",
            "workflow_definitions_directory",
            workflows_dir,
            true
        );

        let success_2 = SetPreferenceValue(
            "All",
            "workflow_only_use_specified_directory",
            "TRUE",
            true
        );

        //Get the Preference value with the given string in the any of admin ("OA_ADMIN") or install ("OA_INSTALL") or home ("OA_HOME") directory oa_pref
        let oa_home_pref;
        let oa_admin_pref;
        let oa_install_pref;
        try {
            let oa_pref = "\\oa_pref";
            let oa_home = `${Getenv("HOMEDRIVE")}${Getenv("HOMEPATH")}`;
            let oa_install = Getenv("OA_INSTALL");
            let oa_admin = Getenv("OA_ADMIN");
            oa_home_pref = oa_home ? oa_home + oa_pref : null;
            oa_install_pref = oa_install ? oa_install + oa_pref : null;
            oa_admin_pref = oa_admin ? oa_admin + oa_pref : null;
        } catch (error) {
            // silently catch error
        }

        //SetPreferenceValue() Returns 0 if the preference is saved succesfully or 1 if unsuccessful
        if (success_1 == 1 || success_2 == 1) {
            Window.Error(
                `oa_pref locked`,
                `The workflow preferences could not be set in your home oa_pref:\n\n    ${oa_home_pref}` +
                    `\n\nThis could be because the preferences are LOCKED in another oa_pref file. ` +
                    `Check the preferences:\n\n    "workflow_definitions_directory"\n    "workflow_only_use_specified_directory"\n\nin:\n` +
                    `${oa_admin_pref ? `\n    ${oa_admin_pref}` : ""}` +
                    `${oa_install_pref ? `\n    ${oa_install_pref}` : ""}`
            );
            Exit();
        }

        Window.Information(
            "Workflows Bundle Installer",
            `Preferences in your HOME oa_pref file have been updated to use the new Workflows directory. Please restart the application and select Workflows from the Tools menu to use the new Workflows bundle.\n\n` +
                "New Workflows location:\n\n    " +
                workflows_dir +
                "\n\nUpdated oa_pref file:\n\n    " +
                oa_home_pref
        );
        return true;
    } else {
        return false;
    }
}
